set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8313436';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-11-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '121',
      '13',
      NULL,
      NULL,
      '1442203',
      130,
      4,
      1.675137,
      3,
      '214124',
      4,
      ' 2- 8-1983',
      18,
      129.935071,
      NULL,
      NULL,
      1,
      0.617863,
      0.574899,
      1,
      1,
      NULL,
      NULL,
      1,
      3,
      0.938131,
      0,
      1,
      0,
      0.225144,
      3.203007,
      NULL,
      1,
      NULL,
      0.913697,
      NULL,
      0.128264,
      0,
      3,
      1,
      NULL,
      1,
      1,
      0.514007,
      NULL,
      NULL,
      1.396867,
      NULL,
      NULL,
      0.192118,
      0,
      0.756905,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.000046,
      0,
      0.679662,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1.522160,
      1,
      0.159291,
      0.619809,
      0,
      1.962828,
      1,
      NULL,
      0.535601,
      3,
      NULL,
      0.693708,
      1.118314,
      1,
      0.887680,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.171874,
      0.906443,
      4.621822,
      3.472732,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      1,
      0.711588,
      6.896120,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.453453,
      4,
      4,
      NULL,
      1,
      NULL,
      NULL,
      3.856339,
      1.862110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.721673,
      1,
      NULL,
      1,
      0.145997,
      1,
      0.378047,
      1.043679,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.586084,
      NULL,
      NULL,
      NULL,
      NULL,
      0.443697,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      3,
      1.535109,
      NULL,
      NULL,
      NULL,
      5.129426,
      0,
      1.975487,
      7,
      1.860969,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.763483,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      1,
      3,
      3.191017,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      1,
      0.042724,
      0.596659,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.005600,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      '22223',
      '',
      '',
      0,
      '',
      NULL,
      '',
      0.777819,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


