set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8313436';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-4-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '434',
      '04',
      NULL,
      NULL,
      '2224140',
      130.448559,
      1,
      0.369474,
      3,
      '232434',
      NULL,
      ' 8-12-1988',
      8,
      58,
      0.235662,
      NULL,
      1,
      1,
      3,
      NULL,
      NULL,
      0,
      1,
      0,
      1.353612,
      1,
      0.960762,
      1.212385,
      NULL,
      NULL,
      4.079127,
      1.776431,
      NULL,
      NULL,
      1,
      1.623094,
      0,
      NULL,
      2,
      0,
      3.419635,
      1.140122,
      3,
      0.746793,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.621498,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.750885,
      2,
      1,
      1,
      1,
      0.800353,
      NULL,
      NULL,
      0.928739,
      3,
      0.167151,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      0.574921,
      0.608214,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.620142,
      0,
      1.173451,
      0,
      2,
      1.320684,
      0,
      1,
      1.370627,
      NULL,
      0,
      3.465802,
      1.776151,
      NULL,
      0.991164,
      0,
      NULL,
      NULL,
      1,
      7.722982,
      0,
      3.673712,
      NULL,
      0.213005,
      2,
      3.983948,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      4,
      0.809678,
      1.241969,
      NULL,
      7,
      7,
      6,
      6,
      5,
      3,
      0,
      0,
      0,
      6.099498,
      0.981328,
      NULL,
      NULL,
      2.416550,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      0,
      NULL,
      0,
      0.514390,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.848384,
      2.178708,
      0.697035,
      0,
      0.766680,
      2,
      6,
      2,
      1.187576,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.541919,
      0,
      0.761837,
      0,
      1.231108,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.433535,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.553559,
      0.036707,
      1.527173,
      3.272329,
      NULL,
      1.687116,
      NULL,
      NULL,
      2.230606,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.189620,
      1.795356,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.269603,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      '',
      '',
      1.438120,
      '',
      '',
      '',
      1.019968,
      '',
      NULL,
      '',
      2.498394,
      3.085404,
      2.866044,
      1.918834,
      1,
      0,
      0.977238,
      NULL,
      3);
commit;
end;
/


