set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8313436';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-6-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '020',
      '14140132',
      0.562268,
      NULL,
      '1430244',
      40,
      4,
      NULL,
      1,
      NULL,
      5,
      '11-13-1998',
      32,
      57.516439,
      1,
      NULL,
      1,
      1,
      0,
      1.769033,
      NULL,
      1.626025,
      0.423985,
      0.167565,
      2.155257,
      0,
      NULL,
      1,
      1,
      0,
      4,
      1,
      3,
      NULL,
      0.539209,
      1,
      0.030159,
      1,
      4.967542,
      1,
      NULL,
      1,
      2.339771,
      0.821513,
      NULL,
      NULL,
      0.030330,
      NULL,
      NULL,
      NULL,
      1.810665,
      0.113553,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.507727,
      3.391164,
      3,
      4.106492,
      0.395480,
      1.006396,
      1.290689,
      0,
      0.987755,
      1.875680,
      0.670319,
      1,
      1,
      NULL,
      0,
      0,
      0.655794,
      0.147172,
      NULL,
      1.172451,
      NULL,
      1.207654,
      NULL,
      5,
      1.925176,
      2.144394,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.439889,
      0.865244,
      0,
      1,
      NULL,
      5,
      5.158285,
      NULL,
      2,
      0.162821,
      6,
      1.148571,
      0.248533,
      0,
      0,
      1,
      NULL,
      NULL,
      4.480042,
      1.712630,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.417691,
      0,
      0,
      1,
      0.675569,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.092922,
      NULL,
      1,
      1.368994,
      2,
      1.031555,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.426099,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2.544036,
      1.281047,
      2,
      1.227092,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.592299,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.744866,
      NULL,
      NULL,
      0,
      1.324280,
      0,
      1,
      NULL,
      0.486910,
      2,
      1,
      0,
      0.038979,
      1,
      0.914375,
      1.457534,
      1,
      0,
      1.091153,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.024081,
      '13012',
      NULL,
      NULL,
      0,
      NULL,
      '',
      NULL,
      0,
      '',
      '',
      '',
      4,
      8,
      1.830779,
      1,
      0.199543,
      1,
      0,
      2.394541,
      NULL);
commit;
end;
/


