set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8313436';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-11-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '421',
      '44013102',
      55,
      58.106423,
      '2134400',
      216,
      NULL,
      1,
      0,
      '242412',
      NULL,
      '11-11-1995',
      14,
      49.098202,
      1.635273,
      NULL,
      1.793775,
      1,
      3.302219,
      1.084836,
      1.012464,
      NULL,
      1,
      1.114589,
      3,
      NULL,
      NULL,
      NULL,
      3,
      1.694312,
      5.434789,
      NULL,
      3,
      1,
      0.994553,
      0,
      NULL,
      1,
      NULL,
      1,
      0.933707,
      NULL,
      NULL,
      1.226339,
      NULL,
      NULL,
      1.001775,
      NULL,
      NULL,
      3.281844,
      0,
      1,
      1,
      NULL,
      NULL,
      1.461709,
      0,
      1.477425,
      0.035983,
      1.036927,
      1,
      0.269797,
      0.400568,
      NULL,
      2,
      0,
      3,
      2.103677,
      NULL,
      0.470611,
      NULL,
      5.580187,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      3,
      NULL,
      0.969272,
      NULL,
      0.421817,
      0,
      0,
      1.290914,
      0.493020,
      1.004392,
      NULL,
      1,
      0.950175,
      0.093959,
      1.678062,
      0,
      NULL,
      0,
      1,
      5,
      0.545739,
      NULL,
      1.314197,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3.647931,
      NULL,
      0.675238,
      0,
      1.133847,
      5,
      NULL,
      6.946127,
      NULL,
      0,
      4.193061,
      8,
      8.995651,
      NULL,
      1.657904,
      3.273501,
      2.418595,
      NULL,
      0,
      7.283710,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1.563739,
      1,
      1.745678,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      3,
      0.138171,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.971265,
      1,
      NULL,
      NULL,
      NULL,
      4.966122,
      0.609684,
      5.054009,
      0.383549,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.149149,
      3,
      1.675256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.932020,
      1,
      2,
      0.809949,
      2.323299,
      3,
      NULL,
      0.498208,
      2.580138,
      0.574650,
      NULL,
      0.400297,
      0,
      0,
      0.377179,
      1.807039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '14330',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      4.186349,
      2,
      3.926322,
      3.604620,
      1,
      2,
      2.599456,
      2.280551,
      2);
commit;
end;
/


