set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8313436';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-6-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '340',
      NULL,
      34,
      NULL,
      '4033121',
      274,
      3,
      1.741902,
      NULL,
      '221224',
      NULL,
      ' 7-21-1978',
      NULL,
      10.108004,
      NULL,
      NULL,
      1.956936,
      0.196813,
      2.168153,
      1,
      1.539368,
      NULL,
      1,
      1,
      NULL,
      0.856081,
      NULL,
      NULL,
      1.948417,
      3.344098,
      NULL,
      NULL,
      2.221229,
      1.454974,
      0.748770,
      1,
      1.739807,
      NULL,
      3,
      1,
      2,
      2,
      NULL,
      1.095857,
      NULL,
      NULL,
      1.457634,
      NULL,
      NULL,
      3,
      0.390517,
      1.986592,
      0.773612,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.053383,
      1,
      0.636161,
      1.911333,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.561899,
      1.801004,
      4,
      3,
      1.617210,
      0.586432,
      1,
      1,
      1,
      1,
      1.657754,
      0,
      0,
      0,
      0,
      NULL,
      1.132361,
      0.840105,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.495802,
      0.186540,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1.018768,
      0,
      2,
      0.247275,
      7.088910,
      2,
      NULL,
      4.772095,
      8,
      5.266907,
      3.196551,
      0,
      2.602323,
      2.050071,
      1.341411,
      NULL,
      4.395725,
      0.501660,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.068647,
      1,
      NULL,
      1,
      0,
      0.100286,
      1,
      0.008981,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.213638,
      NULL,
      8.143504,
      2,
      2.611268,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      6,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.653384,
      3.549712,
      3,
      0.988201,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.567391,
      1.483806,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      3.100887,
      0,
      NULL,
      1.023689,
      0,
      1,
      3,
      0,
      1,
      1,
      1.742199,
      1,
      0.015527,
      NULL,
      1.910207,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.951958,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '',
      NULL,
      0.557771,
      '',
      '',
      '',
      0.240333,
      '',
      '',
      NULL,
      3,
      0.782732,
      1.836081,
      2,
      1.414039,
      2,
      3,
      NULL,
      NULL);
commit;
end;
/


