set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8313436';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-7-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '412',
      '31221141',
      75,
      28,
      NULL,
      72.830919,
      5,
      NULL,
      0,
      '114143',
      4.237732,
      ' 8-22-1985',
      13.368622,
      NULL,
      0,
      NULL,
      1,
      1.072971,
      1,
      0.031779,
      1,
      0,
      0.540928,
      0.750480,
      NULL,
      0,
      0.706944,
      0.584231,
      1,
      0,
      NULL,
      1,
      2.457454,
      1.493596,
      0.464387,
      0.512797,
      0.003239,
      1,
      1.188421,
      0,
      5.312621,
      1,
      3,
      0.565034,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.152389,
      NULL,
      NULL,
      2,
      1.710695,
      1.334465,
      NULL,
      1.371304,
      1,
      NULL,
      0,
      0,
      0,
      0.452696,
      2.521829,
      NULL,
      3.509190,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      1.664849,
      1.379689,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.158518,
      0,
      1,
      0.544118,
      NULL,
      NULL,
      1,
      1.127349,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      0.988231,
      0,
      NULL,
      0.671347,
      7,
      0,
      1,
      1.942442,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      6.413132,
      1.738952,
      1.265716,
      4.493270,
      6,
      6,
      NULL,
      6,
      7,
      1.948616,
      2,
      2.969879,
      1.719969,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0.468527,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.722277,
      0.895001,
      0,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.894191,
      1.885814,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0.649673,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.459786,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.781500,
      1,
      3,
      2.846563,
      2,
      NULL,
      2,
      0,
      2,
      1.158761,
      0.899064,
      0,
      0.630176,
      0.457395,
      0.386602,
      0.834164,
      1,
      1.288646,
      1.978744,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.018036,
      NULL,
      '',
      NULL,
      0.001915,
      '',
      '',
      '',
      0.417141,
      '',
      NULL,
      '',
      2.207768,
      0,
      2.632324,
      0.505276,
      NULL,
      3,
      2.258972,
      2,
      NULL);
commit;
end;
/


