set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8313436';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-12-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0234',
      NULL,
      15.758313,
      80.962352,
      '3213342',
      310,
      6,
      2,
      NULL,
      '242431',
      1.935387,
      NULL,
      16.716966,
      56,
      NULL,
      NULL,
      1.803339,
      1.756486,
      0.430286,
      0,
      0.242216,
      NULL,
      0,
      1.299161,
      3,
      0.584165,
      1,
      0,
      2.401190,
      1.173184,
      7,
      0,
      3.897089,
      1.766198,
      1,
      0,
      0.765643,
      1.414495,
      2,
      NULL,
      2.678352,
      3,
      3,
      1.618538,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      1,
      0.093559,
      0,
      NULL,
      0,
      NULL,
      3,
      1,
      0,
      1,
      1,
      2,
      0,
      1.674012,
      0,
      NULL,
      NULL,
      NULL,
      0.279222,
      0,
      1,
      1,
      2.478975,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.067453,
      3.498572,
      1.475161,
      5,
      0.647317,
      0,
      1.477382,
      0,
      0.097502,
      NULL,
      0.469574,
      0,
      0,
      NULL,
      NULL,
      1,
      0.610543,
      NULL,
      NULL,
      1.120520,
      1,
      0,
      NULL,
      0.104549,
      0.261873,
      3,
      0,
      6.064912,
      0.446528,
      NULL,
      1,
      3.081024,
      2,
      4,
      1.510978,
      2.295636,
      1,
      0,
      3.466341,
      6.362075,
      6.690797,
      2.782518,
      4,
      3,
      4,
      NULL,
      2,
      2,
      NULL,
      0,
      3.213252,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.769507,
      0.554856,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.333428,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.231741,
      1.859367,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.269688,
      1.109541,
      2,
      1.388602,
      0,
      0.361302,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.708203,
      3,
      3.918340,
      3.187089,
      3.184081,
      NULL,
      NULL,
      2.722097,
      2.377493,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1,
      0.737619,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.422199,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.143294,
      NULL,
      '',
      '',
      1.212293,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '',
      4,
      NULL,
      3.156767,
      NULL,
      1.294117,
      3.228065,
      3.933631,
      NULL,
      2);
commit;
end;
/


