set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9330628';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-12-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '0',
      NULL,
      NULL,
      '0101442',
      13,
      5,
      NULL,
      NULL,
      '433141',
      2,
      ' 7- 8-1999',
      15,
      NULL,
      1,
      NULL,
      3,
      NULL,
      0,
      0,
      NULL,
      2,
      0,
      1,
      NULL,
      0,
      0.932049,
      0.057129,
      1.262405,
      NULL,
      3.863570,
      1,
      7,
      1.488419,
      0.230220,
      2,
      0,
      1.343182,
      4,
      1,
      4,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.386988,
      NULL,
      NULL,
      1.965946,
      1.869845,
      1.569628,
      NULL,
      0,
      1.260027,
      NULL,
      1,
      3.659157,
      1.098603,
      2.002980,
      1.676787,
      1,
      NULL,
      1,
      3,
      3.877922,
      1,
      0.263631,
      1,
      1.162856,
      0,
      2,
      1,
      0,
      1.371226,
      0,
      NULL,
      NULL,
      1.255430,
      NULL,
      NULL,
      0,
      0.822844,
      0.465889,
      1.473258,
      1,
      0.926535,
      NULL,
      0.500317,
      1.545326,
      NULL,
      1.824474,
      NULL,
      0,
      1,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      1.859263,
      3,
      1.170449,
      NULL,
      0.861175,
      0.519457,
      0,
      NULL,
      1.159220,
      0,
      0.469673,
      1.147869,
      NULL,
      1.373501,
      1.571455,
      0,
      0.706447,
      2,
      1,
      0,
      3.657888,
      NULL,
      3.698417,
      2.439783,
      4.006380,
      1.401057,
      0.637755,
      0.563674,
      1.747829,
      0.200067,
      0,
      8.072549,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0.935332,
      0.944547,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.605922,
      NULL,
      1,
      1,
      1.529838,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.624753,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1.059651,
      7,
      0.413405,
      0,
      2,
      7.974629,
      NULL,
      2,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.969702,
      2,
      1.164121,
      0.346701,
      1,
      0,
      1.638937,
      1.775076,
      2,
      0,
      1.629939,
      1.809901,
      0,
      1,
      NULL,
      1.614433,
      1.017989,
      0,
      1.568951,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '33344',
      NULL,
      '',
      0.584935,
      '',
      '',
      '',
      0.479929,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


