set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9330628';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-2-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      NULL,
      NULL,
      NULL,
      NULL,
      43,
      2,
      1,
      0,
      '330214',
      0,
      NULL,
      NULL,
      NULL,
      0.097628,
      NULL,
      1,
      1,
      1.976555,
      NULL,
      0.574304,
      3,
      1,
      1.547096,
      2,
      1.425376,
      0.517361,
      0,
      1.940200,
      0,
      2,
      1.945416,
      2.112049,
      0,
      0.554876,
      0,
      1,
      0.338814,
      0.860216,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.909956,
      NULL,
      NULL,
      1.477116,
      0,
      NULL,
      3,
      1,
      0.411265,
      1,
      NULL,
      0,
      1.980878,
      0.992001,
      1.324611,
      1,
      NULL,
      NULL,
      0.158694,
      1.008119,
      0,
      1.577441,
      1,
      5.881412,
      3,
      1,
      NULL,
      NULL,
      0.618250,
      1.285341,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.073094,
      NULL,
      1.293671,
      NULL,
      2.423736,
      NULL,
      1,
      0.981674,
      0.459619,
      1.089907,
      1.375187,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      0.196181,
      0.063581,
      NULL,
      0,
      2,
      0.636169,
      1,
      1,
      0,
      1.081964,
      0.766985,
      NULL,
      0.891694,
      1,
      NULL,
      1.516613,
      NULL,
      1,
      0.486672,
      1,
      2.971595,
      5.669924,
      5,
      3,
      6.433798,
      0.736768,
      0.956729,
      NULL,
      NULL,
      3.047287,
      0.375545,
      NULL,
      NULL,
      0,
      NULL,
      1.791418,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      1.848000,
      0.147429,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      2,
      2.174879,
      1.479016,
      0.541054,
      NULL,
      3.270808,
      0,
      NULL,
      3.493291,
      9.944032,
      2.007517,
      0.754900,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      4,
      1.875195,
      0,
      0,
      4.776410,
      1.086357,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.731325,
      NULL,
      NULL,
      3,
      0.031859,
      1,
      3.985682,
      1.513130,
      1,
      0.285171,
      0,
      1.389037,
      1.042873,
      1.826015,
      NULL,
      0.901360,
      0,
      0.605681,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.515382,
      '11413',
      '',
      '',
      0.881504,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


