set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9330628';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-6-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '2',
      NULL,
      NULL,
      '0331304',
      38,
      NULL,
      0,
      NULL,
      '212443',
      1.035026,
      ' 2-11-2002',
      54.326865,
      NULL,
      1.206652,
      NULL,
      1,
      NULL,
      0.906182,
      NULL,
      1.533026,
      1.162241,
      1.078379,
      1.429034,
      0.647954,
      0.740980,
      NULL,
      1.801181,
      1.913827,
      4,
      1,
      0,
      0.107802,
      1,
      NULL,
      NULL,
      1,
      0.002057,
      6,
      NULL,
      5.310507,
      0,
      1.700121,
      1.192454,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.520213,
      1.169930,
      1.255911,
      0.512988,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.333793,
      1.139107,
      NULL,
      0.416987,
      0.116560,
      3.739236,
      0.585792,
      0.780118,
      1,
      1,
      NULL,
      4,
      1,
      1,
      0.417022,
      0.655893,
      NULL,
      NULL,
      1.377045,
      NULL,
      NULL,
      0,
      1.619102,
      1.912531,
      NULL,
      NULL,
      1,
      0.856846,
      0,
      1,
      1,
      1.850481,
      NULL,
      0,
      0.947719,
      NULL,
      1,
      1,
      0.745892,
      0.509548,
      NULL,
      NULL,
      1.791686,
      0,
      1,
      1,
      NULL,
      1.051640,
      1,
      5,
      1,
      NULL,
      NULL,
      NULL,
      0.370244,
      7.109300,
      NULL,
      1.515631,
      2.295174,
      2.843303,
      NULL,
      0,
      4,
      2,
      0,
      5,
      0.537634,
      NULL,
      2,
      3,
      1.401531,
      0,
      0.283261,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.989954,
      0,
      0.484362,
      0.793062,
      3,
      0.373940,
      0.363701,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.204305,
      4,
      0,
      4.535563,
      NULL,
      NULL,
      NULL,
      NULL,
      4.422630,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2,
      3,
      1.335083,
      1.026599,
      1.136858,
      1,
      1,
      0,
      1.367331,
      1.180906,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.137498,
      NULL,
      '',
      '',
      1.639330,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


