set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9330628';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-11-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '113',
      '04',
      NULL,
      10,
      '3014224',
      46.151275,
      4,
      1.517511,
      NULL,
      NULL,
      4.518445,
      ' 4- 2-1984',
      23,
      7.531773,
      1,
      NULL,
      0,
      1,
      2,
      1,
      NULL,
      1,
      0,
      1.177798,
      3,
      1.328656,
      5.388247,
      NULL,
      NULL,
      3.112435,
      5.834812,
      NULL,
      8,
      0,
      0,
      1,
      1,
      NULL,
      4.226581,
      1,
      5.518710,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.340617,
      1,
      NULL,
      0,
      1.307529,
      0,
      0.443157,
      0,
      1.986249,
      0,
      0,
      3.697746,
      1,
      1.620071,
      0.098590,
      1,
      NULL,
      NULL,
      0,
      1,
      2,
      NULL,
      0.157962,
      NULL,
      NULL,
      0.419960,
      NULL,
      NULL,
      1.542916,
      1,
      0,
      5,
      NULL,
      1,
      1.371142,
      0,
      0.602572,
      NULL,
      0.655258,
      0,
      0.256959,
      1.319965,
      1.750781,
      0,
      NULL,
      1.373556,
      0,
      NULL,
      1.091106,
      0,
      0.825888,
      NULL,
      1.692544,
      0,
      0.164781,
      1.693596,
      2.984077,
      0,
      1,
      NULL,
      0,
      0.515212,
      0,
      NULL,
      0.967624,
      3.181691,
      1.980371,
      1.435505,
      4.994394,
      5,
      2.989760,
      5.122920,
      4,
      1,
      3,
      4,
      1,
      NULL,
      0.510006,
      5.813469,
      0.084449,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      0.251925,
      1.656456,
      0.604875,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.686939,
      NULL,
      0,
      0.523138,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.357035,
      3.339130,
      1.774404,
      NULL,
      NULL,
      NULL,
      1.387990,
      1,
      2.253884,
      NULL,
      5.762631,
      0,
      3.681224,
      1.033898,
      NULL,
      NULL,
      1,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1.605873,
      1,
      1,
      0,
      1,
      0.565355,
      0,
      0.615121,
      1.697502,
      NULL,
      0.275427,
      0.686881,
      1.089417,
      0,
      0.148924,
      0.072818,
      1.372331,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '34200',
      '',
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      '',
      NULL,
      NULL,
      4.593165,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


