set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9330628';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-5-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '411',
      NULL,
      13.296770,
      6.507059,
      NULL,
      2.014355,
      0,
      3.405153,
      0,
      '022020',
      3,
      ' 6-27-1979',
      12,
      48,
      1.899915,
      NULL,
      0,
      0,
      2.552986,
      0.193244,
      0.018466,
      1.555571,
      NULL,
      1,
      3.996704,
      0.991462,
      1.678659,
      1,
      2,
      7,
      0.333583,
      3.022432,
      8.142286,
      NULL,
      NULL,
      1,
      NULL,
      3.885579,
      3.982991,
      1,
      0,
      2,
      3.789764,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.027460,
      0,
      1,
      2.258789,
      1,
      NULL,
      NULL,
      1.530399,
      0,
      1,
      0.016961,
      1,
      NULL,
      0,
      0,
      0.287961,
      3.554623,
      0,
      1.502539,
      0,
      4.356884,
      NULL,
      4,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.461395,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.920077,
      1,
      0.104953,
      1.948601,
      0,
      0,
      1.030194,
      1.327074,
      1,
      1.055886,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      0.766867,
      1,
      0.211956,
      0.205488,
      NULL,
      NULL,
      NULL,
      1.611375,
      NULL,
      0.539867,
      0,
      0,
      1.168772,
      NULL,
      0,
      2,
      6.158462,
      5.718329,
      5,
      NULL,
      4,
      3,
      1,
      NULL,
      1,
      1.423024,
      NULL,
      9.086417,
      1.178990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.149270,
      0.984455,
      1,
      1,
      0.873942,
      0,
      NULL,
      0.544354,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.473572,
      1.121572,
      NULL,
      3.162954,
      3,
      0,
      0,
      3,
      1.275350,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.429350,
      NULL,
      4,
      0.375169,
      2,
      NULL,
      6,
      1.247820,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.594188,
      NULL,
      NULL,
      1,
      3.083496,
      1.941865,
      NULL,
      3.591776,
      1.059285,
      2,
      0.876543,
      1,
      0,
      0.129188,
      1,
      0,
      1.126071,
      0,
      1.138737,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      '',
      '',
      0,
      '',
      NULL,
      '',
      0.701754,
      '',
      NULL,
      '',
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


