set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9330628';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-7-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '233',
      '31',
      39.214980,
      NULL,
      NULL,
      3.900882,
      NULL,
      2,
      1,
      '421430',
      4,
      NULL,
      51,
      69.510540,
      0.927147,
      NULL,
      0.314302,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      5,
      0.116130,
      0.693082,
      7.309351,
      4.753600,
      1.331493,
      11,
      NULL,
      1,
      0,
      4,
      3.224831,
      4.681882,
      0,
      3,
      5.850776,
      2,
      0.135074,
      NULL,
      NULL,
      1.987073,
      NULL,
      NULL,
      NULL,
      0.673448,
      1.299812,
      3,
      0.845935,
      0,
      NULL,
      1.417375,
      0.536015,
      NULL,
      0,
      NULL,
      1.271276,
      1.271974,
      1,
      2.007458,
      1.088411,
      1,
      1.049838,
      0,
      NULL,
      1.163925,
      6,
      1,
      2,
      3,
      0.881606,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.437115,
      5.831711,
      5,
      1.069633,
      1,
      0,
      0,
      0,
      0,
      1.186307,
      1.288578,
      1,
      0.092643,
      1,
      0.911835,
      0.937018,
      0.214275,
      NULL,
      1.904492,
      1.973710,
      1.601156,
      1.183801,
      0,
      0.181393,
      0,
      NULL,
      1.068207,
      1.593013,
      1.465627,
      0,
      0.124776,
      0,
      NULL,
      1,
      0.307831,
      1,
      1,
      3.203099,
      2,
      0,
      0,
      4.079248,
      2.705191,
      1.967833,
      0,
      1,
      1,
      NULL,
      0.327672,
      9,
      0.405211,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2,
      0.262838,
      1.384238,
      1,
      0.295174,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.832727,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.621071,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.169117,
      1,
      1,
      0.999677,
      NULL,
      0.605597,
      0,
      NULL,
      NULL,
      0.100460,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.104115,
      3.756379,
      3.819614,
      NULL,
      0,
      0,
      0,
      0,
      1.704160,
      NULL,
      0.144686,
      0,
      0,
      NULL,
      0,
      0.636165,
      1,
      NULL,
      0.274028,
      0.168258,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.112597,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.211825,
      NULL,
      NULL,
      NULL,
      NULL,
      0.396705,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.616922,
      1,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      '41230',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


