set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9330628';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-11-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '433',
      '20',
      34.843917,
      8,
      '1011134',
      93.863785,
      4,
      1.013275,
      NULL,
      NULL,
      5.306271,
      ' 3-12-2000',
      10.487264,
      37.837787,
      NULL,
      NULL,
      0.854270,
      NULL,
      NULL,
      0,
      0.223856,
      0.902973,
      0.969066,
      NULL,
      NULL,
      NULL,
      2,
      1.121436,
      NULL,
      1,
      3,
      0.319616,
      5,
      0,
      1,
      1,
      11,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.395209,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.157818,
      0,
      NULL,
      1.677875,
      NULL,
      1,
      2.786904,
      NULL,
      0,
      NULL,
      0.182512,
      NULL,
      0.801435,
      1.122958,
      3,
      2.226035,
      1,
      NULL,
      1.598336,
      0.279873,
      NULL,
      NULL,
      5,
      0,
      0,
      1,
      1.916384,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.659578,
      0,
      3,
      2,
      0,
      NULL,
      1,
      1.430276,
      0.480701,
      1.348641,
      0,
      NULL,
      1.340879,
      0.331866,
      0.657410,
      0,
      0,
      NULL,
      NULL,
      0.318698,
      0.724734,
      NULL,
      1.207028,
      1,
      1.058339,
      0.008516,
      3.659153,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.976646,
      3.727215,
      0.176698,
      0,
      1.908931,
      0,
      1.315714,
      5.347606,
      0,
      NULL,
      1.785614,
      5.669099,
      1.890116,
      0.452612,
      3,
      2,
      1.600073,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.690627,
      NULL,
      NULL,
      NULL,
      NULL,
      0.075316,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.590960,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.110878,
      0,
      1.517631,
      0,
      2,
      1,
      NULL,
      NULL,
      0,
      4.303432,
      1.118334,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.429231,
      1,
      1,
      1.228330,
      1,
      3,
      NULL,
      3.682600,
      1,
      1,
      1.755890,
      0.960463,
      1.164461,
      0.557649,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.745644,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '12111',
      '',
      NULL,
      0.002337,
      NULL,
      '',
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


