set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9330628';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-12-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '144',
      '3',
      43,
      46.550133,
      '3422102',
      115,
      NULL,
      2,
      3,
      NULL,
      5,
      ' 5- 8-1977',
      55,
      2.375773,
      1,
      NULL,
      0.084772,
      0.029960,
      NULL,
      0,
      0,
      1,
      1.223355,
      0.373580,
      3.144899,
      1.927988,
      1,
      0.464586,
      0.322370,
      0,
      0.958930,
      1,
      3,
      1,
      1,
      1,
      NULL,
      0.631641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.651667,
      1,
      1,
      1.328835,
      NULL,
      0.088703,
      3,
      0,
      0.508877,
      1,
      NULL,
      1.590255,
      0.042187,
      1.825264,
      NULL,
      1,
      2.450581,
      1,
      1.890550,
      0,
      0.784270,
      0,
      5.658175,
      NULL,
      1,
      1.360466,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.110782,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      1.453738,
      1,
      NULL,
      0.267390,
      1.341049,
      1.756812,
      0.559099,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      0.535678,
      1.031003,
      0.780536,
      0,
      0.734416,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.314647,
      NULL,
      0.090783,
      0,
      0,
      NULL,
      NULL,
      1.563032,
      0.741453,
      0,
      0.047926,
      5,
      1,
      NULL,
      NULL,
      0.403248,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.434391,
      0,
      0,
      0.764164,
      NULL,
      0.579268,
      1.193137,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.270884,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.133055,
      1.747886,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.618885,
      1,
      1,
      NULL,
      2,
      0,
      0.148181,
      1,
      0,
      NULL,
      1.031943,
      NULL,
      0,
      0,
      NULL,
      1.249626,
      1,
      1.781866,
      1.697287,
      1.304810,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.498124,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.591651,
      NULL,
      NULL,
      NULL,
      NULL,
      0.708094,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.290188,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      '41023',
      '',
      '',
      NULL,
      '',
      NULL,
      NULL,
      0,
      NULL,
      '',
      '',
      3.734590,
      3,
      1.209983,
      1,
      0.434591,
      3,
      3.305163,
      0,
      NULL);
commit;
end;
/


