set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9330628';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-1-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '021',
      '40312030',
      53,
      9.830149,
      '2012311',
      NULL,
      NULL,
      3,
      0,
      '203114',
      2.590034,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.771386,
      0.336471,
      0.405764,
      0.913030,
      NULL,
      0,
      0.049499,
      2.108674,
      1,
      2,
      0.398194,
      3.066824,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.488651,
      NULL,
      1,
      7.942996,
      1,
      5.099062,
      2,
      0.059875,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.305703,
      0,
      1,
      1.312757,
      0,
      0.507579,
      2.989033,
      0,
      0,
      NULL,
      3,
      1.507790,
      0.678464,
      0,
      0.624777,
      3.615066,
      0,
      1.759751,
      0,
      NULL,
      9.944050,
      3.561564,
      3.511271,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      3.930276,
      3.231258,
      NULL,
      1,
      1.812640,
      1,
      0,
      1.057539,
      0,
      0.463255,
      0,
      1.200882,
      1,
      0.275798,
      0.269281,
      NULL,
      0.085855,
      NULL,
      1.904986,
      0,
      1.533195,
      1,
      1,
      1.387674,
      NULL,
      0,
      1.744418,
      3.907776,
      0,
      2,
      1.713242,
      NULL,
      2,
      1.320402,
      1.565303,
      NULL,
      0,
      1,
      2.454170,
      3,
      1.315217,
      NULL,
      NULL,
      1,
      2.535441,
      0.405991,
      NULL,
      0,
      NULL,
      0.506654,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      0,
      1.689329,
      1.592464,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.293251,
      1.119267,
      NULL,
      0.270218,
      4.430234,
      1,
      0.647971,
      NULL,
      NULL,
      NULL,
      2.128041,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.356020,
      1.835611,
      NULL,
      1,
      1.792890,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.039274,
      0.912760,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.203237,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.901923,
      1,
      NULL,
      NULL,
      1.314713,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.830982,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0.296576,
      NULL,
      0,
      2,
      0,
      '23042',
      NULL,
      '',
      1.142555,
      '',
      '',
      '',
      0.796990,
      NULL,
      '',
      NULL,
      2.769065,
      7,
      NULL,
      2.110909,
      0,
      0.945452,
      NULL,
      1.834250,
      2.120414);
commit;
end;
/


