set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9330628';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-12-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '434',
      NULL,
      13,
      10,
      '3331343',
      22,
      5,
      NULL,
      0,
      '410231',
      4.227253,
      ' 1- 7-1978',
      2.230553,
      0,
      0,
      NULL,
      0.588030,
      1,
      0.904785,
      0.967131,
      1,
      0,
      1.402505,
      0.609939,
      3.498621,
      1.004891,
      NULL,
      5.936485,
      2,
      3,
      2,
      1.162711,
      NULL,
      NULL,
      0,
      NULL,
      2,
      3,
      2,
      0,
      0,
      1.292286,
      NULL,
      1.050188,
      NULL,
      NULL,
      0.971030,
      NULL,
      NULL,
      6.376657,
      NULL,
      1,
      2.882312,
      1,
      0,
      0,
      1.307956,
      3,
      0.128241,
      3.433177,
      1,
      0,
      1,
      2.051947,
      2.824734,
      NULL,
      1,
      NULL,
      NULL,
      1.309622,
      2,
      1,
      0,
      2,
      1.932800,
      1.748882,
      NULL,
      NULL,
      1.410443,
      NULL,
      NULL,
      0,
      NULL,
      3.379989,
      NULL,
      2,
      1.785772,
      1.144985,
      1,
      NULL,
      0,
      0.109200,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      0.378666,
      NULL,
      NULL,
      0,
      1,
      1.480994,
      0.893418,
      NULL,
      NULL,
      1,
      1.328357,
      3.131938,
      0,
      3.797183,
      2.768027,
      3.811330,
      1.300413,
      0.202324,
      0,
      0.250586,
      2.650462,
      0,
      0.957733,
      4.127097,
      3.084066,
      0.225900,
      NULL,
      NULL,
      NULL,
      5,
      0,
      1.278244,
      1.854079,
      0.812504,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.836499,
      0.094993,
      2,
      0,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.006174,
      NULL,
      4,
      3.078458,
      NULL,
      1.148689,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.014253,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      2,
      5.003744,
      0,
      9.771897,
      0.277727,
      NULL,
      NULL,
      1.756469,
      1.365052,
      0.235030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.179478,
      0.339657,
      0,
      1.340933,
      1,
      0,
      NULL,
      3,
      1.504543,
      1,
      NULL,
      1.832052,
      0,
      1,
      1.749463,
      0,
      1,
      NULL,
      0.631661,
      0.472019,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.693895,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.243923,
      '42332',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      0,
      3.209937,
      NULL,
      3.431953,
      0,
      NULL,
      NULL,
      NULL);
commit;
end;
/


