set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9330628';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-12-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '100',
      NULL,
      2.214359,
      7,
      '4100342',
      191.473316,
      0,
      3.530541,
      3,
      '222000',
      3,
      ' 3- 6-1984',
      51.998542,
      NULL,
      0,
      NULL,
      1.619779,
      3,
      1,
      1.735710,
      0,
      NULL,
      NULL,
      1,
      1,
      0.574919,
      4,
      NULL,
      1.908218,
      4,
      NULL,
      1,
      NULL,
      0.947974,
      0,
      NULL,
      2.775482,
      1,
      3,
      0,
      3.233690,
      0.623609,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5,
      5.659315,
      NULL,
      0.939835,
      NULL,
      0.921920,
      0.003599,
      1.672959,
      0.459922,
      1.159597,
      NULL,
      3.787423,
      1.055158,
      NULL,
      NULL,
      0.166449,
      3.985920,
      NULL,
      NULL,
      0.162182,
      1,
      NULL,
      2.113101,
      4.037810,
      0,
      1,
      0.135974,
      1,
      NULL,
      NULL,
      NULL,
      0.632003,
      0.009448,
      1.336613,
      0,
      NULL,
      4,
      5,
      1,
      1.103740,
      0,
      1,
      0.724650,
      1.616913,
      0,
      1.682200,
      0.847298,
      0,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      3,
      1,
      1.792438,
      0,
      0,
      1.510826,
      1,
      0,
      5.618171,
      7,
      7,
      0,
      1.797307,
      3.026336,
      NULL,
      0.827839,
      2.943486,
      3,
      NULL,
      5,
      NULL,
      NULL,
      2.016297,
      2,
      0.565664,
      0.740701,
      0,
      NULL,
      0,
      1.448610,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0.643743,
      NULL,
      2.207624,
      1.221577,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.465209,
      3.175297,
      0.032171,
      NULL,
      NULL,
      NULL,
      5.807967,
      0.554141,
      NULL,
      2,
      NULL,
      1,
      7,
      1.642605,
      NULL,
      NULL,
      2.651397,
      5,
      1.583554,
      NULL,
      5,
      6,
      4,
      1.479156,
      0,
      0.915603,
      0.325915,
      NULL,
      1,
      2,
      1.970298,
      0,
      NULL,
      NULL,
      0,
      1.240830,
      1,
      0.189072,
      1,
      0,
      NULL,
      0,
      0.221029,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.265361,
      '00224',
      '',
      '',
      1,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      4.531280,
      5.723361,
      1.561402,
      1.974793,
      1,
      2,
      NULL,
      NULL,
      4.376906);
commit;
end;
/


