set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9330628';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-8-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4103',
      '03032043',
      50,
      45.968976,
      '1204403',
      NULL,
      3,
      1.816298,
      NULL,
      '323031',
      NULL,
      ' 4- 3-1976',
      51,
      56.904121,
      NULL,
      NULL,
      0,
      NULL,
      3.922875,
      1,
      0.823500,
      NULL,
      1,
      1.906603,
      1.141034,
      NULL,
      1.280734,
      0.234095,
      1,
      0.715021,
      1.530894,
      0.916311,
      0,
      NULL,
      1,
      0.485603,
      NULL,
      1,
      1.527699,
      NULL,
      0.337609,
      1,
      0,
      1.057504,
      NULL,
      NULL,
      1.336148,
      NULL,
      NULL,
      2,
      1,
      1.070645,
      3.046116,
      0,
      1,
      0,
      2,
      1.718754,
      0,
      0.424112,
      1,
      NULL,
      2.415888,
      0,
      2,
      1.589284,
      0.220966,
      1,
      1,
      0,
      7.912601,
      3,
      0,
      0,
      0.076923,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.173926,
      NULL,
      1,
      5.264241,
      1,
      0.475035,
      0,
      1,
      1,
      0,
      NULL,
      1.340921,
      1,
      0.365785,
      NULL,
      1,
      1.136766,
      0.257892,
      0.063739,
      NULL,
      0,
      0,
      1.760241,
      0,
      1,
      NULL,
      5.382196,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.989715,
      2.448493,
      0.825927,
      0,
      2.993234,
      NULL,
      2,
      4.338845,
      5.373141,
      5.763971,
      5,
      5.326578,
      0.887097,
      0,
      0,
      0,
      0,
      NULL,
      9.469552,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      0.073761,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.675114,
      1,
      1.928659,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      7.525380,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2,
      1.283099,
      3,
      2.547993,
      0,
      0,
      NULL,
      1,
      0.210894,
      0,
      NULL,
      NULL,
      NULL,
      0.554424,
      1.383333,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      2,
      '4300',
      '',
      '',
      NULL,
      1,
      0,
      5,
      NULL,
      3.194611,
      3,
      0,
      1);
commit;
end;
/


