set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9330628';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-12-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3201',
      '01341242',
      27.051405,
      29.268974,
      '4404040',
      NULL,
      4,
      NULL,
      3,
      '140340',
      1,
      ' 3-25-2003',
      36,
      29,
      NULL,
      NULL,
      1,
      1.711607,
      2,
      0.531577,
      1.032636,
      NULL,
      NULL,
      0.354555,
      0,
      1,
      0.756267,
      1.017660,
      0.854222,
      3.804526,
      2.948398,
      1,
      NULL,
      0.538858,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      3,
      0.143623,
      0.380723,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.192113,
      0.632398,
      2.830090,
      0,
      1.677716,
      NULL,
      NULL,
      1.474476,
      1.318199,
      NULL,
      NULL,
      1.570668,
      NULL,
      2,
      0,
      1.342571,
      NULL,
      1.596438,
      1.585670,
      NULL,
      2.806796,
      NULL,
      NULL,
      1,
      1.733973,
      0.170931,
      NULL,
      NULL,
      1.027560,
      NULL,
      NULL,
      0.124056,
      1.824482,
      1,
      NULL,
      2,
      1.952209,
      NULL,
      0,
      0,
      1.439876,
      1,
      0.591768,
      NULL,
      1.367644,
      1,
      1,
      0.790311,
      NULL,
      1.064434,
      NULL,
      0,
      3.695158,
      0,
      1.383019,
      NULL,
      1.085026,
      3,
      2.597306,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.907774,
      NULL,
      1,
      2,
      NULL,
      0.217462,
      2.003165,
      1,
      1,
      NULL,
      3,
      0,
      1,
      0,
      1,
      0.137353,
      0.146900,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      NULL,
      NULL,
      1,
      1.799893,
      1.891084,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.655308,
      0,
      NULL,
      1.587304,
      1,
      NULL,
      1.544809,
      NULL,
      NULL,
      NULL,
      NULL,
      0.012926,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      0,
      0.443591,
      1,
      1.785461,
      2.509302,
      1.568160,
      3.203914,
      1.606925,
      0.286771,
      0.179400,
      NULL,
      1.156500,
      NULL,
      0,
      0,
      1,
      0.587750,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.989913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '20230',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      0.322137,
      2,
      3,
      1.022343,
      1,
      0,
      1,
      3,
      NULL);
commit;
end;
/


