set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9330628';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-6-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0421',
      '21234422',
      47.478843,
      72,
      '4211033',
      242.395421,
      3,
      2,
      1,
      '143403',
      5.102364,
      ' 9-24-1999',
      NULL,
      24.234528,
      0,
      NULL,
      1.444009,
      0,
      2,
      1.378586,
      0.305809,
      0.717995,
      1.390743,
      1,
      3.641653,
      1.802682,
      2,
      0,
      0,
      2,
      0,
      0,
      NULL,
      1,
      1.365607,
      1,
      1,
      NULL,
      4.776537,
      0,
      2.027091,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1.106689,
      0.255227,
      0.604818,
      1.198735,
      1,
      1,
      0.462634,
      1.132411,
      2.334558,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      1.554379,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      1.049936,
      1.458115,
      NULL,
      NULL,
      1.285260,
      NULL,
      NULL,
      0.226038,
      NULL,
      1.130924,
      2.283313,
      2,
      1.235545,
      0.055925,
      1,
      NULL,
      1,
      NULL,
      1,
      1,
      0.634548,
      0.773574,
      1,
      0.889860,
      1.140768,
      1.697526,
      NULL,
      0,
      4.616166,
      NULL,
      0,
      2,
      1.865405,
      5,
      0.676230,
      NULL,
      NULL,
      NULL,
      NULL,
      7.758302,
      0.750664,
      1.384758,
      0,
      1.428328,
      3,
      NULL,
      0.033432,
      NULL,
      NULL,
      NULL,
      5.200062,
      NULL,
      1.012530,
      NULL,
      NULL,
      NULL,
      1,
      0,
      4.352034,
      0.007979,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.214320,
      1.873429,
      2,
      2,
      NULL,
      1.546083,
      0.634321,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.196120,
      1.846041,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.817010,
      NULL,
      NULL,
      NULL,
      NULL,
      3.898484,
      1,
      3.630194,
      2.709654,
      0.298181,
      2,
      7.695595,
      NULL,
      NULL,
      NULL,
      1.611676,
      NULL,
      0.578156,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.355715,
      NULL,
      1.025493,
      0,
      NULL,
      0,
      NULL,
      1,
      2,
      NULL,
      1,
      1.250946,
      1,
      0,
      1,
      1.204903,
      1,
      0.629261,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      '',
      NULL,
      0.551984,
      '',
      '',
      NULL,
      2.438226,
      '3043',
      '',
      '',
      1.973463,
      1.819189,
      2.853570,
      NULL,
      0.884244,
      5,
      0,
      3.237225,
      0.196127);
commit;
end;
/


