set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9330628';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-12-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2230',
      NULL,
      79,
      46.016621,
      '0024140',
      NULL,
      NULL,
      0,
      2,
      '422141',
      6.075988,
      NULL,
      28,
      3.543672,
      NULL,
      NULL,
      0,
      0,
      2.187543,
      1.505958,
      1,
      1,
      1,
      1.819464,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.909404,
      NULL,
      1.191289,
      1,
      1,
      0.960020,
      0.134214,
      1.957207,
      2,
      0,
      3.900400,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.423185,
      NULL,
      NULL,
      3,
      0.072234,
      NULL,
      1.678762,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.766596,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      0.446883,
      1,
      0,
      1,
      1.076269,
      NULL,
      0,
      1.916812,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0.493148,
      0.408839,
      NULL,
      1,
      0,
      0.254062,
      NULL,
      0,
      0.428479,
      1.833334,
      1.716941,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.648033,
      NULL,
      NULL,
      1.357323,
      5,
      6.043162,
      2,
      4.773645,
      1.193069,
      4.398594,
      0,
      1,
      1.187177,
      1.890930,
      0.272399,
      NULL,
      NULL,
      7.796158,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0.311856,
      1,
      0.298649,
      1.165250,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      5.153379,
      0,
      3.918892,
      0.157571,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.776127,
      2,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.485973,
      3.201140,
      5,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.216048,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.541084,
      1.741957,
      3,
      NULL,
      3.896940,
      1.436415,
      0.986782,
      0,
      0,
      1,
      NULL,
      0,
      0.489564,
      1,
      1.717803,
      0.863530,
      1.831388,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.350096,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.321563,
      '31410',
      '',
      '',
      0,
      '',
      '',
      NULL,
      0,
      NULL,
      '',
      '',
      NULL,
      3.454823,
      2.728155,
      2,
      5.293359,
      1.379088,
      1,
      0,
      0);
commit;
end;
/


