set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9330628';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-6-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1141',
      '02310341',
      91.895035,
      78,
      '1410142',
      93.156355,
      4,
      1.728809,
      1,
      '040101',
      1.211292,
      ' 3-17-1978',
      40.195608,
      NULL,
      1.945578,
      NULL,
      1.514023,
      0,
      3.209090,
      1.347564,
      NULL,
      0.382126,
      1,
      1.335154,
      1,
      1.943872,
      0,
      1,
      0,
      1,
      NULL,
      0,
      1.371496,
      0,
      1,
      0,
      0,
      NULL,
      0.190140,
      1,
      0.991800,
      1.283906,
      0,
      1.675297,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.383608,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.214654,
      0,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      4,
      4,
      4.646175,
      1.737380,
      1.528839,
      1,
      0,
      0,
      0,
      NULL,
      1,
      0,
      1.147643,
      1.048214,
      1.197536,
      NULL,
      0,
      NULL,
      1,
      5.959332,
      NULL,
      1.665482,
      1.637823,
      1.101067,
      1.623765,
      3.443751,
      NULL,
      NULL,
      NULL,
      NULL,
      1.919783,
      1.997493,
      0,
      NULL,
      NULL,
      1,
      2.278794,
      4.611448,
      3,
      NULL,
      5,
      2.322536,
      1,
      1.506683,
      1.280833,
      0.744601,
      NULL,
      NULL,
      NULL,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      1.140178,
      1,
      0.188004,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.136498,
      NULL,
      0.240624,
      2.722588,
      NULL,
      2,
      1.738198,
      0.750774,
      1,
      0.207106,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.325634,
      NULL,
      NULL,
      1.490700,
      3,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.761297,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.207074,
      0.978736,
      2.295227,
      0,
      0,
      3.279544,
      1.505815,
      3.228715,
      0,
      1,
      1.916632,
      0,
      0,
      1.253412,
      1.644042,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '00030',
      NULL,
      '',
      1,
      NULL,
      '',
      '',
      3.193690,
      NULL,
      NULL,
      '',
      3,
      3.678030,
      2,
      7.248556,
      2.462304,
      NULL,
      1,
      0.942977,
      NULL);
commit;
end;
/


