set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9206296';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-3-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '123',
      '02004301',
      44.898484,
      15,
      '2211322',
      120.262493,
      5,
      3,
      NULL,
      NULL,
      0.924146,
      NULL,
      11,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.915890,
      1.204684,
      0,
      NULL,
      1.050005,
      1.191907,
      1.777248,
      0,
      2.709950,
      NULL,
      1.922933,
      3.197057,
      NULL,
      NULL,
      0,
      1.884357,
      1,
      0,
      3.383717,
      1.776835,
      3.809730,
      0,
      5,
      2.378521,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.713890,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.129794,
      NULL,
      0.464304,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.597190,
      1.597266,
      0,
      2,
      5.210665,
      1.184507,
      0.309590,
      NULL,
      6,
      NULL,
      NULL,
      4,
      1,
      1,
      NULL,
      NULL,
      0.535524,
      NULL,
      NULL,
      1.251805,
      1.551396,
      1,
      1.670824,
      3.035462,
      NULL,
      1.158239,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.265541,
      NULL,
      NULL,
      6.474871,
      3.179033,
      2.994979,
      3.339858,
      5.318803,
      NULL,
      3.672577,
      1,
      1.190460,
      0.641044,
      0,
      NULL,
      NULL,
      5,
      0.075045,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.985292,
      NULL,
      2,
      NULL,
      0.711861,
      NULL,
      NULL,
      1.943370,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.783748,
      NULL,
      NULL,
      NULL,
      9.174367,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      4.718241,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.702343,
      3.495435,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.776767,
      0.394862,
      1.665996,
      1.495880,
      0,
      2.683850,
      NULL,
      NULL,
      1.205181,
      1.387731,
      0.962672,
      NULL,
      NULL,
      1,
      0.611631,
      0,
      1.523838,
      0.030732,
      NULL,
      0.574015,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.536762,
      '42210',
      '',
      '',
      3.444400,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      0.381160,
      NULL,
      NULL,
      NULL,
      0,
      0.590203,
      2,
      1,
      1.030959);
commit;
end;
/


