set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9206296';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-5-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '210',
      '32341201',
      65,
      NULL,
      '3214024',
      210,
      NULL,
      3,
      1,
      '110330',
      5.815531,
      ' 4-26-1996',
      52.012151,
      186.518822,
      0.808585,
      NULL,
      1,
      0,
      2,
      0.919151,
      1.434810,
      1,
      0.737587,
      3.113270,
      0,
      0,
      1.799906,
      1,
      4.985551,
      1.627502,
      1,
      1,
      2,
      1.237747,
      1.555615,
      NULL,
      5,
      1.840457,
      NULL,
      0,
      5,
      1,
      2.028265,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.653551,
      NULL,
      0,
      0.409344,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.937393,
      1,
      NULL,
      1.254174,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      0.008516,
      2,
      NULL,
      0.446118,
      1.033080,
      NULL,
      0.296657,
      1,
      1,
      0,
      0,
      NULL,
      1.860633,
      1.851514,
      0.028651,
      0.365328,
      0,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2.452089,
      NULL,
      2.916055,
      0.954685,
      0,
      NULL,
      6.460588,
      NULL,
      2.058008,
      3,
      1,
      2,
      NULL,
      0.466687,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1.025848,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.759548,
      1,
      1,
      1,
      0,
      0.053921,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.452880,
      NULL,
      3.020563,
      2.520449,
      0,
      1.490452,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.652072,
      NULL,
      0,
      0.544283,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.711729,
      1.306832,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.172571,
      3,
      1,
      1.429567,
      3.056045,
      3,
      1,
      NULL,
      0.063407,
      NULL,
      0.683609,
      0.795543,
      1,
      0,
      NULL,
      0,
      1,
      0,
      0.975276,
      0.084572,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.900931,
      '4041',
      '',
      '',
      2,
      '04014',
      NULL,
      '',
      1.816203,
      '',
      NULL,
      '',
      3,
      3,
      3,
      1.904975,
      NULL,
      2,
      NULL,
      3.641898,
      NULL);
commit;
end;
/


