set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9206296';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-10-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '223',
      NULL,
      20,
      72.337726,
      '0124044',
      77,
      5,
      NULL,
      2,
      '401133',
      NULL,
      ' 3- 7-1977',
      55.424085,
      21.202680,
      NULL,
      NULL,
      0,
      1,
      3,
      0.961525,
      0,
      0.719692,
      NULL,
      2.833652,
      0.298492,
      1,
      3,
      0.002818,
      5.508536,
      0,
      3.993788,
      1.993742,
      4,
      1.339052,
      NULL,
      NULL,
      5,
      0.063725,
      2,
      0,
      2,
      3.475186,
      2.788090,
      0.549974,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.798059,
      NULL,
      1.634254,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.520197,
      1,
      1.159786,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      NULL,
      4,
      1.242510,
      0.578943,
      1,
      1,
      1,
      0,
      4.112324,
      0,
      0,
      0,
      0,
      1,
      NULL,
      0.432554,
      0.502574,
      1,
      1,
      NULL,
      1.791971,
      1.999957,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.616930,
      1.110117,
      0.725156,
      1.544091,
      NULL,
      7.830310,
      0,
      3,
      7,
      NULL,
      3,
      NULL,
      6,
      0,
      0.149229,
      0.765498,
      1,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.900756,
      0,
      0,
      1,
      1.315889,
      1.816384,
      0.608876,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.491845,
      NULL,
      1.057125,
      2.999660,
      2.626828,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      5.629477,
      1,
      0,
      NULL,
      0.205272,
      NULL,
      NULL,
      NULL,
      0.771887,
      0.114203,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.999926,
      3.238555,
      2,
      0.722879,
      3.412339,
      NULL,
      0,
      1.525298,
      1,
      1,
      0,
      1.439657,
      1.371015,
      1.130171,
      NULL,
      NULL,
      1,
      NULL,
      1.565799,
      0.051447,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.175402,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '3004',
      '',
      '',
      2.981023,
      NULL,
      '',
      NULL,
      NULL,
      '',
      NULL,
      '',
      5,
      0,
      0.856197,
      3.091871,
      1,
      2,
      2,
      3.764962,
      2.990939);
commit;
end;
/


