set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9206296';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-10-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0024',
      '44432023',
      60.619905,
      75,
      '3303123',
      193.130230,
      4,
      2,
      2,
      '131101',
      5.241104,
      ' 1-27-1994',
      57,
      33,
      0,
      NULL,
      0.045471,
      1.633991,
      2.911228,
      1,
      NULL,
      NULL,
      NULL,
      2.798467,
      1.765094,
      0,
      0.929950,
      0,
      1.157405,
      0,
      5,
      0.708667,
      3.285900,
      0.314945,
      0.566368,
      NULL,
      4,
      1,
      1,
      1,
      NULL,
      0.225398,
      2,
      NULL,
      NULL,
      NULL,
      0.544023,
      NULL,
      NULL,
      NULL,
      1.889921,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.380436,
      0.795523,
      NULL,
      1.055406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.524019,
      0,
      1,
      0.141805,
      0,
      NULL,
      0,
      0,
      0.525507,
      4,
      1.355412,
      0.462169,
      1,
      0.578121,
      0,
      NULL,
      1.754442,
      1,
      0,
      NULL,
      NULL,
      0,
      1.399471,
      1,
      0.599060,
      1.890147,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2.658447,
      0,
      1,
      NULL,
      1,
      3.064295,
      NULL,
      0,
      0,
      9.762266,
      NULL,
      2,
      5,
      1,
      NULL,
      0.864576,
      NULL,
      NULL,
      NULL,
      0,
      0.951583,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      1.548111,
      0.157929,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.559159,
      NULL,
      8.372908,
      2.667203,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.061381,
      3.355067,
      1,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0.722891,
      1,
      2,
      3.998663,
      NULL,
      2.112033,
      0.538809,
      NULL,
      1,
      0,
      1,
      NULL,
      0.537720,
      NULL,
      0,
      0.594786,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.647283,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.861591,
      '1024',
      '',
      '',
      0.556396,
      '42210',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      0.232610,
      1,
      NULL,
      NULL,
      2.477994,
      1,
      3.549900,
      3.420302);
commit;
end;
/


