set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9206296';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-5-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3043',
      NULL,
      16.737680,
      37,
      '3041421',
      155,
      3,
      0,
      0,
      '120431',
      0,
      NULL,
      58.062503,
      2,
      1.881738,
      NULL,
      1.028217,
      0,
      NULL,
      1.741140,
      0,
      0.834112,
      1,
      2,
      0,
      0,
      2.315459,
      1,
      3,
      3.831465,
      5.715189,
      0.135075,
      5.346929,
      0,
      0,
      0,
      NULL,
      0,
      4.279579,
      0,
      NULL,
      0.170489,
      0.696363,
      0.472264,
      NULL,
      NULL,
      1.126806,
      NULL,
      NULL,
      NULL,
      NULL,
      1.265985,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.665108,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.074695,
      0.888602,
      0.521770,
      1.755561,
      3.315354,
      0,
      1,
      1,
      0,
      1.053393,
      1,
      NULL,
      4,
      0.685619,
      0,
      0.857610,
      0,
      NULL,
      NULL,
      0.640768,
      1,
      0,
      0.611445,
      0,
      NULL,
      1,
      1.042044,
      NULL,
      NULL,
      NULL,
      NULL,
      3.309906,
      0.083427,
      NULL,
      0,
      0.922577,
      5.628371,
      NULL,
      6.364421,
      2.994548,
      1.316158,
      6.216792,
      2,
      0,
      1,
      0,
      0.588789,
      1,
      NULL,
      NULL,
      NULL,
      0.071738,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.507594,
      0,
      0,
      NULL,
      1.373676,
      1.773136,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.166306,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.987761,
      2.718575,
      1,
      NULL,
      2.966693,
      0,
      1.304235,
      NULL,
      5.520653,
      1.939441,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.052422,
      3,
      0.777154,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.935659,
      3.225309,
      1,
      1.580262,
      2.446071,
      NULL,
      1,
      NULL,
      1.430446,
      0.078890,
      0,
      0,
      0,
      1.857251,
      0.492100,
      0,
      1.474604,
      NULL,
      1.949060,
      0.357110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.041350,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '3344',
      '',
      NULL,
      NULL,
      '03103',
      NULL,
      '',
      0,
      '',
      '',
      '',
      5,
      5.824288,
      NULL,
      2,
      0.513690,
      NULL,
      1,
      2,
      NULL);
commit;
end;
/


