set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8925214';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-2-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '012',
      '00',
      NULL,
      1.794303,
      '3220044',
      60,
      2,
      3.668195,
      0,
      NULL,
      2.734390,
      ' 6-29-2003',
      49.727015,
      14.823181,
      0,
      NULL,
      NULL,
      0,
      2,
      0,
      NULL,
      1.160189,
      1,
      0,
      1.801007,
      0.980965,
      0.268147,
      0,
      1.144956,
      NULL,
      1,
      NULL,
      3,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.075675,
      0.412484,
      0,
      NULL,
      NULL,
      0.092109,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.071091,
      0,
      0,
      1.560681,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.742023,
      2,
      NULL,
      0.671368,
      NULL,
      1.870712,
      5,
      1.235250,
      1.395565,
      3,
      NULL,
      0,
      NULL,
      3.826827,
      1,
      1.145944,
      NULL,
      NULL,
      NULL,
      NULL,
      0.896920,
      NULL,
      NULL,
      1.344421,
      6.098618,
      NULL,
      NULL,
      0.442529,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      2,
      0,
      NULL,
      1.708358,
      1,
      2,
      4.369950,
      0,
      9,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      6,
      0.557592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.430681,
      2,
      0,
      0.089173,
      0.216591,
      1,
      0.785158,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.176039,
      NULL,
      NULL,
      NULL,
      NULL,
      4.869590,
      1,
      NULL,
      1,
      0,
      2.378272,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.844377,
      1.649250,
      0.816103,
      1,
      0.060281,
      1,
      1.705229,
      NULL,
      NULL,
      NULL,
      NULL,
      2.998026,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.356311,
      NULL,
      NULL,
      1,
      1,
      0.096617,
      0.339457,
      2,
      NULL,
      3,
      0.797229,
      1.690893,
      NULL,
      0,
      0.274214,
      NULL,
      1,
      1.440718,
      1,
      0.077459,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.100639,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.892585,
      '2011',
      NULL,
      '',
      1,
      '',
      '',
      '',
      0.883580,
      NULL,
      '',
      NULL,
      2.760797,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


