set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8925214';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-8-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '424',
      '24',
      NULL,
      1.291911,
      NULL,
      27.027568,
      NULL,
      3.484303,
      2,
      '220313',
      5,
      NULL,
      34.961324,
      31.774164,
      1,
      NULL,
      NULL,
      1,
      0.790728,
      0,
      0.992367,
      0,
      0,
      2.390340,
      1.847687,
      1.903422,
      3,
      0.755436,
      0.519710,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.420092,
      NULL,
      1,
      0.306835,
      NULL,
      0.235085,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      0.896188,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.734401,
      1,
      NULL,
      1.122803,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      4.499809,
      1.659854,
      1,
      1.236133,
      0.474606,
      NULL,
      1.229114,
      NULL,
      0.175628,
      NULL,
      0.013842,
      1.043138,
      0.859832,
      0,
      1.598611,
      NULL,
      NULL,
      1,
      2,
      1,
      0,
      0.992831,
      2.470762,
      1,
      0.123492,
      0.057618,
      NULL,
      1.816860,
      1,
      1.245490,
      0.603158,
      3,
      0,
      1.482863,
      1,
      1,
      4,
      3,
      5,
      0,
      0.178979,
      1.261945,
      1.598980,
      3.484941,
      NULL,
      NULL,
      NULL,
      8.229566,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5.185189,
      0.155939,
      1,
      1.542708,
      0.759119,
      3.214041,
      8,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.158546,
      1,
      0.767431,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.646326,
      0,
      1.222235,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      1,
      0,
      0.648724,
      0.216812,
      NULL,
      2.127452,
      0.148777,
      0,
      NULL,
      0.869910,
      1.153986,
      0.504859,
      0.417177,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      '',
      '',
      1.229850,
      '',
      NULL,
      '',
      0.513629,
      '',
      '',
      NULL,
      NULL,
      2.633505,
      2,
      0,
      2,
      2,
      0,
      NULL,
      NULL);
commit;
end;
/


