set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8925214';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-9-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '003',
      NULL,
      35,
      56,
      '3032414',
      138.054806,
      5,
      2.675159,
      1,
      '223120',
      6,
      ' 3-24-1983',
      45.751700,
      20,
      NULL,
      NULL,
      1.507371,
      0.050814,
      NULL,
      0,
      1,
      1.870086,
      1,
      3.411826,
      0,
      0,
      NULL,
      0,
      1.185517,
      5.055957,
      0,
      0.421725,
      2,
      1,
      1.077915,
      0.786191,
      1.781864,
      1.056622,
      0,
      1,
      NULL,
      0,
      0.249923,
      1.859989,
      NULL,
      NULL,
      1.008778,
      NULL,
      NULL,
      1.747987,
      1,
      1.116919,
      0.131079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.025136,
      NULL,
      1,
      1.728805,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.201658,
      1,
      2.443174,
      1,
      NULL,
      0.834680,
      1,
      NULL,
      0,
      0.188600,
      NULL,
      5,
      NULL,
      0,
      0.323794,
      0.143188,
      1.751702,
      NULL,
      1.963451,
      0.453660,
      0.941910,
      0,
      0.256302,
      0,
      NULL,
      1.298569,
      1,
      1.847714,
      1,
      0.225735,
      1.065673,
      1.482366,
      1.600365,
      0,
      1,
      1,
      3,
      NULL,
      1.345125,
      5.349713,
      NULL,
      7,
      9.119457,
      1.704956,
      NULL,
      1,
      1.264005,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1.687989,
      0.698704,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.857581,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.923658,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.492258,
      NULL,
      NULL,
      2,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.610956,
      2.407659,
      1,
      0.225835,
      2.680600,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.841962,
      NULL,
      1,
      1.477176,
      0,
      NULL,
      NULL,
      0.086397,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.426997,
      '20232',
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      1,
      NULL,
      0,
      3,
      1,
      3,
      0.361510,
      NULL);
commit;
end;
/


