set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8925214';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-8-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '310',
      '03020143',
      NULL,
      NULL,
      '4120124',
      72,
      NULL,
      1.479144,
      0,
      '000413',
      4,
      ' 9-26-1996',
      0.410932,
      53.980169,
      0.684208,
      NULL,
      1.237779,
      0,
      NULL,
      1.265938,
      1,
      1.783564,
      0.531342,
      1.463702,
      1,
      0,
      0.628083,
      NULL,
      1,
      5,
      NULL,
      5.399784,
      1,
      1,
      NULL,
      NULL,
      0.735438,
      0.362543,
      3,
      1,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.901385,
      0,
      1.238468,
      1.220521,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      1.856409,
      0,
      NULL,
      0.573281,
      1,
      1,
      0.371913,
      1.369116,
      1,
      0.343042,
      0.802196,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      0.138264,
      0,
      2.492420,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.171909,
      1.013740,
      1.866419,
      NULL,
      2,
      0,
      4,
      2,
      5.550962,
      NULL,
      9.391542,
      NULL,
      NULL,
      1,
      1.339246,
      1.825268,
      NULL,
      NULL,
      7,
      0.605894,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.424847,
      1,
      0,
      NULL,
      1.035020,
      0,
      0.188339,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.743569,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.890668,
      3.927893,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.644830,
      NULL,
      2.572616,
      0,
      0,
      0.686799,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.949617,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.702367,
      0,
      NULL,
      1,
      1.191862,
      0.783211,
      NULL,
      0,
      0.200411,
      1,
      NULL,
      0.785555,
      1,
      0,
      0,
      1.772630,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.810213,
      '10431',
      '',
      '',
      0.456926,
      NULL,
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      1,
      3,
      0,
      2.112048,
      0,
      2.930961,
      1.794022,
      2.942267,
      3.593217);
commit;
end;
/


