set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8925214';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-1-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '430',
      '32441034',
      22.867389,
      49,
      '4420143',
      6,
      3,
      0.265248,
      0,
      '342010',
      5,
      ' 9- 5-1992',
      NULL,
      48.361683,
      1.505994,
      NULL,
      0,
      3,
      1,
      1.641666,
      0.107661,
      0.479569,
      NULL,
      3,
      1,
      1,
      0.030315,
      NULL,
      NULL,
      2,
      1.230949,
      1,
      4.998191,
      1.636618,
      0,
      1.891366,
      1,
      1.364539,
      3.022893,
      1,
      1,
      0,
      1,
      1.644389,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.132953,
      0,
      0.923441,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.175866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.475430,
      0.143721,
      0.626164,
      2.198421,
      1.633403,
      1.269798,
      5,
      NULL,
      1.738379,
      0,
      NULL,
      NULL,
      1,
      1.864806,
      NULL,
      0.140670,
      NULL,
      1,
      0.856976,
      0,
      NULL,
      0.969908,
      NULL,
      0.663868,
      NULL,
      NULL,
      NULL,
      0.873752,
      0,
      0.638225,
      0.332678,
      0.289769,
      1,
      0.905076,
      7.557525,
      3.673991,
      2.794163,
      4.594728,
      2,
      0,
      5,
      3,
      0,
      1.255200,
      1,
      0.824654,
      NULL,
      NULL,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.504417,
      0,
      1,
      0,
      1.945232,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.811368,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.266280,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.517757,
      0,
      0,
      1.515343,
      0,
      NULL,
      0.015590,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.484557,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.896435,
      3,
      NULL,
      NULL,
      1.297944,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.721724,
      1,
      1,
      0.177333,
      1,
      1,
      0,
      1.232746,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '41012',
      '',
      '',
      1.836549,
      '',
      '',
      '',
      0.168798,
      '',
      '',
      '',
      2.755375,
      2,
      2,
      2.178467,
      NULL,
      NULL,
      0,
      3.831874,
      2.816111);
commit;
end;
/


