set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8925214';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-8-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3410',
      NULL,
      NULL,
      29.290889,
      '0410330',
      122,
      NULL,
      0.930903,
      3,
      '003122',
      NULL,
      ' 7-17-1990',
      NULL,
      45,
      0.586375,
      NULL,
      0,
      3,
      0,
      1.156362,
      0.529224,
      1,
      0.870842,
      0.330782,
      NULL,
      NULL,
      0,
      0.574801,
      1.641478,
      4.300098,
      1,
      NULL,
      1,
      1.262885,
      0.275874,
      0.906145,
      0.867791,
      0.800608,
      0.278460,
      1,
      0,
      1.689265,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.755175,
      0,
      NULL,
      1.244832,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.489620,
      0.727325,
      0.187205,
      0.319053,
      0,
      1,
      0,
      1,
      1,
      6.564004,
      1.736330,
      NULL,
      NULL,
      NULL,
      0,
      0.806075,
      NULL,
      1.500607,
      0.354807,
      NULL,
      0,
      0,
      NULL,
      1.772108,
      1.706951,
      1.784158,
      1.897317,
      0.151021,
      0.720998,
      0.327922,
      NULL,
      1,
      1.049025,
      1,
      1.201837,
      NULL,
      0.703358,
      5.799178,
      1.034447,
      4,
      5.595890,
      4.221733,
      3,
      NULL,
      7.843428,
      0.608744,
      1.936850,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      1,
      1.767109,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.740895,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.304523,
      1,
      0,
      NULL,
      NULL,
      NULL,
      5.875850,
      0.883071,
      1,
      0.872153,
      0,
      NULL,
      0.762325,
      NULL,
      NULL,
      NULL,
      NULL,
      3.989625,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.816112,
      1.746915,
      1,
      NULL,
      0.236595,
      1,
      NULL,
      0,
      0,
      1.561220,
      0.595442,
      0.664627,
      NULL,
      1,
      1,
      0.450001,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.848814,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '14002',
      NULL,
      '',
      1.841315,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      3.172143,
      2.430705,
      0,
      1,
      2,
      1,
      2,
      NULL,
      2.684342);
commit;
end;
/


