set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8925214';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-3-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2130',
      '20120021',
      38.184830,
      NULL,
      '3100020',
      26,
      6,
      NULL,
      NULL,
      '211234',
      2,
      ' 4- 1-1996',
      41.889869,
      39.556637,
      0.292723,
      NULL,
      0.155361,
      0,
      2,
      0.908928,
      1.791426,
      0,
      1,
      0,
      NULL,
      0.698932,
      NULL,
      1,
      5,
      5.838635,
      0.494655,
      0,
      1.798799,
      NULL,
      0,
      1.516431,
      0,
      NULL,
      2.254778,
      1,
      NULL,
      3,
      0,
      0.841840,
      NULL,
      NULL,
      0.659463,
      NULL,
      NULL,
      0,
      1.366770,
      1,
      0.733175,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.823189,
      0,
      1.428030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.897302,
      5.498512,
      5.457074,
      1,
      1.864821,
      0,
      0.879254,
      1,
      0.616357,
      2.132341,
      0.180081,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      0.359648,
      0,
      1,
      1.020351,
      1,
      0.746512,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0.927863,
      0,
      2.491483,
      0.567487,
      3.115455,
      5.835641,
      1,
      7.576285,
      NULL,
      4.698233,
      0,
      0,
      0.266759,
      1.854285,
      NULL,
      0.171920,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.535228,
      1.761429,
      NULL,
      1,
      0,
      1.745783,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.879037,
      2.190954,
      0.115917,
      NULL,
      NULL,
      NULL,
      5.338671,
      1,
      4,
      0.454010,
      2.915672,
      0,
      1.922486,
      NULL,
      NULL,
      NULL,
      1.155548,
      2,
      1.280261,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.643855,
      3,
      3,
      1,
      1.183634,
      3,
      0.948591,
      3,
      NULL,
      1.959442,
      NULL,
      1,
      1.281169,
      1.909368,
      0,
      1.108965,
      1.226710,
      NULL,
      1.050350,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      '',
      '',
      1,
      NULL,
      '',
      NULL,
      1.115482,
      '',
      NULL,
      '',
      0,
      3,
      3.925029,
      1,
      NULL,
      NULL,
      3.637051,
      3.157589,
      NULL);
commit;
end;
/


