set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8925214';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-9-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4443',
      '31321013',
      35.660935,
      19.854369,
      '1104302',
      125,
      6,
      3.884096,
      0,
      '220444',
      NULL,
      '11-19-1991',
      20,
      NULL,
      1,
      NULL,
      0.750704,
      0.840756,
      0,
      0.015982,
      NULL,
      0,
      1.939255,
      3.558848,
      1.945928,
      1.898759,
      0.922676,
      0,
      1,
      1.057773,
      1.075948,
      0,
      4,
      1,
      0,
      NULL,
      0,
      1.115458,
      3,
      NULL,
      3.343400,
      1.541630,
      0.741401,
      1.433267,
      NULL,
      NULL,
      1.309810,
      NULL,
      NULL,
      1,
      1,
      1.207150,
      0.939333,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.445935,
      0.005195,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.269133,
      2,
      0,
      0.181403,
      1,
      0.634638,
      4,
      0.432428,
      1.062128,
      NULL,
      4.927219,
      0,
      NULL,
      3,
      1,
      0.148825,
      NULL,
      0.406894,
      0.214687,
      NULL,
      0.330384,
      NULL,
      0.528067,
      0.142853,
      3,
      2,
      2.062786,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      1.796050,
      1,
      4,
      0.573203,
      3,
      0.412531,
      5,
      4,
      9,
      0,
      NULL,
      NULL,
      0.656393,
      1.102613,
      0,
      2.884646,
      1,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.496568,
      1.616889,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.301360,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.595964,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4.465473,
      0.034871,
      NULL,
      0,
      1.346464,
      1,
      1.886749,
      NULL,
      NULL,
      NULL,
      0.652694,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.024165,
      0,
      1,
      2.045535,
      0.952316,
      2.448342,
      0,
      NULL,
      1.396164,
      NULL,
      1,
      1.439114,
      1.006528,
      NULL,
      0.957424,
      1.540487,
      1,
      1.775649,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.326264,
      '44123',
      NULL,
      '',
      0.922814,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      NULL,
      5,
      2.103353,
      5.726125,
      NULL,
      3.890909,
      3.284482,
      1.255820,
      0.912753);
commit;
end;
/


