set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8925214';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-2-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4341',
      '13331202',
      96.445384,
      26,
      '3024130',
      207.452377,
      0,
      NULL,
      2,
      NULL,
      NULL,
      '11- 9-1991',
      20,
      10.873217,
      0.756684,
      NULL,
      NULL,
      NULL,
      0.117235,
      1.764247,
      1.238120,
      1,
      0.747404,
      NULL,
      0,
      0.716900,
      5,
      0.033721,
      0,
      0,
      1.385002,
      0.460325,
      NULL,
      0,
      1.564471,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.946244,
      2.484139,
      0.970571,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.219082,
      0.112920,
      0.628001,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.554557,
      1,
      NULL,
      0.481269,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      3,
      5,
      1.491069,
      1.898573,
      4.581735,
      NULL,
      1,
      1.270412,
      3.293574,
      1,
      NULL,
      0,
      1,
      1.175563,
      NULL,
      1,
      1.927915,
      3,
      1,
      2,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      0.811080,
      NULL,
      NULL,
      0,
      5,
      0,
      3,
      1,
      3,
      0,
      1.892800,
      4,
      NULL,
      0,
      NULL,
      4,
      NULL,
      1,
      NULL,
      NULL,
      9.575174,
      0.250021,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.821753,
      1,
      NULL,
      1,
      1,
      1,
      3.045400,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.935122,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.010636,
      0.343729,
      NULL,
      NULL,
      NULL,
      NULL,
      3.008961,
      NULL,
      0,
      0.568003,
      2,
      1.475817,
      NULL,
      NULL,
      NULL,
      0,
      3.894176,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.670951,
      1.293040,
      0.783339,
      0.268899,
      0,
      NULL,
      NULL,
      1,
      1.523677,
      0,
      0.942668,
      1,
      NULL,
      1.094522,
      NULL,
      0,
      1.394990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '03232',
      '',
      '',
      1,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      2.270915,
      NULL,
      3.567301,
      2.009389,
      NULL,
      0.258087,
      3.132466,
      0);
commit;
end;
/


