set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9303656';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-9-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '232',
      NULL,
      NULL,
      15.771864,
      '3422040',
      15.432839,
      6,
      0,
      2,
      '012223',
      5.365840,
      ' 2- 1-1974',
      32.484811,
      30.970734,
      1,
      NULL,
      0,
      2,
      NULL,
      1,
      0,
      NULL,
      3.742004,
      NULL,
      1,
      NULL,
      5,
      0,
      NULL,
      1,
      1.129456,
      NULL,
      7,
      0,
      NULL,
      NULL,
      5,
      0.275425,
      7,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.959527,
      0,
      1.196643,
      0,
      3,
      3.615275,
      3,
      NULL,
      3,
      0,
      NULL,
      3,
      1,
      3.281230,
      2.528157,
      3.266164,
      NULL,
      0.718994,
      0,
      0,
      NULL,
      0,
      2,
      3,
      NULL,
      NULL,
      NULL,
      1.607502,
      NULL,
      NULL,
      3,
      1,
      3.539152,
      1,
      2,
      1.448461,
      NULL,
      1.069028,
      1.783020,
      0,
      1,
      0.831394,
      NULL,
      1,
      0.604182,
      NULL,
      0.715048,
      0,
      NULL,
      NULL,
      NULL,
      2.783601,
      3,
      1.644318,
      0.610358,
      0.082031,
      0,
      0,
      0.984583,
      NULL,
      1.297307,
      NULL,
      0.718576,
      1,
      0,
      NULL,
      0,
      4.612457,
      4,
      8.788492,
      1,
      2,
      3.391316,
      11.804339,
      0.863659,
      3.927282,
      0,
      2.846402,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.611660,
      2,
      1,
      0,
      0.797675,
      1,
      1.189665,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.374779,
      NULL,
      0.471333,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.326306,
      1.646914,
      3,
      2,
      0,
      3.950724,
      2,
      NULL,
      4.231504,
      3.411633,
      5.139632,
      1,
      2,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      2.237033,
      1,
      NULL,
      3.916810,
      1.477813,
      3.488671,
      0,
      NULL,
      1.597122,
      1.169837,
      1.971363,
      1,
      1.268973,
      0.429573,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.442057,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      '',
      NULL,
      1.071078,
      '',
      '',
      '',
      4.549470,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


