set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9303656';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-3-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '012',
      '31',
      19.066130,
      0.967012,
      '4313103',
      25.987937,
      1,
      2.555470,
      2,
      '303011',
      0.158264,
      ' 5-12-1987',
      60.437650,
      0,
      0.293042,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.851270,
      0,
      3,
      3.075483,
      1,
      1.908652,
      NULL,
      1,
      0,
      0.617814,
      1.416831,
      1,
      5,
      1,
      NULL,
      1.082065,
      2,
      3,
      1.237383,
      NULL,
      1,
      3,
      0.302052,
      1,
      NULL,
      NULL,
      1.658079,
      NULL,
      NULL,
      0,
      1.785849,
      NULL,
      1.742573,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4.784554,
      1.176441,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      0.920888,
      NULL,
      1,
      0,
      0,
      1,
      0,
      0,
      NULL,
      0.328340,
      NULL,
      0,
      NULL,
      1.323244,
      0.587347,
      1.149014,
      NULL,
      0.552309,
      0.289365,
      0.392365,
      NULL,
      1,
      NULL,
      3,
      5,
      NULL,
      NULL,
      3,
      NULL,
      2,
      7.437096,
      6.183751,
      8,
      0.924342,
      2,
      1.989290,
      4,
      3.141875,
      2.633131,
      1,
      9.145189,
      1.181177,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.490266,
      0,
      0,
      1,
      1.876193,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.171590,
      1.669910,
      NULL,
      0,
      1,
      3.624836,
      3,
      3.681626,
      1.160590,
      0,
      11,
      3,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2.430346,
      2.530010,
      2.606432,
      3.265607,
      NULL,
      4.604426,
      1.518353,
      NULL,
      NULL,
      0,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      3.036095,
      3.452810,
      NULL,
      NULL,
      3,
      0.520068,
      NULL,
      0,
      1,
      0.141374,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.037936,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.325027,
      '30444',
      NULL,
      '',
      0,
      '',
      NULL,
      '',
      0.637463,
      '',
      '',
      '',
      3.408545,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


