set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8530746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-7-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '34',
      NULL,
      NULL,
      '3440412',
      49,
      6,
      2.507254,
      3,
      '001402',
      4,
      NULL,
      42.341759,
      4,
      1.592799,
      NULL,
      0,
      1.767879,
      1,
      0,
      1.040361,
      0,
      0.398314,
      1.831547,
      0,
      0,
      5.923880,
      1,
      0,
      1,
      0,
      NULL,
      3,
      0,
      1.881285,
      0.270054,
      NULL,
      NULL,
      1.232293,
      1,
      NULL,
      1.745821,
      1.667070,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.413909,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.973999,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.668615,
      1.480064,
      3,
      NULL,
      1.284114,
      0,
      1.517247,
      NULL,
      0.712421,
      0.368943,
      1,
      1.859541,
      0.628531,
      NULL,
      0,
      0,
      1.135571,
      0.081188,
      1,
      NULL,
      0.441186,
      5.929713,
      0,
      0,
      NULL,
      0.167226,
      3,
      1.593309,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4.805985,
      0,
      0.230832,
      NULL,
      5.665683,
      4.246265,
      4.629801,
      4.738558,
      NULL,
      3,
      1.191361,
      1.369558,
      NULL,
      NULL,
      2.143586,
      0.890015,
      NULL,
      NULL,
      5.981187,
      1.640198,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.208620,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.438302,
      0,
      1.061148,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.204827,
      2.593490,
      1.430935,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      4.690176,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.600761,
      1.333500,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.991205,
      0.659648,
      1.434940,
      NULL,
      0.260300,
      0.873832,
      0.396474,
      0.089807,
      1,
      3.168928,
      1,
      1,
      1.764691,
      NULL,
      1.333396,
      1.765803,
      1.834271,
      0.500215,
      1,
      0.759233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.670669,
      '33041',
      '44004',
      '44022',
      1,
      '',
      '',
      '',
      1.749357,
      NULL,
      '',
      '',
      3.697683,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


