set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8530746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-1-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '020',
      NULL,
      NULL,
      23.829056,
      '0424240',
      NULL,
      3,
      2.163479,
      1,
      '343410',
      3,
      ' 8- 2-2001',
      44.351049,
      57.368611,
      0,
      NULL,
      0.218372,
      1.862892,
      2.504766,
      0.686653,
      1,
      NULL,
      1,
      NULL,
      0.772983,
      0.049523,
      3,
      0,
      0,
      1.901240,
      0,
      1,
      4.964164,
      0.705022,
      NULL,
      0.082595,
      1.471610,
      1,
      1,
      0,
      NULL,
      3,
      1.482597,
      0,
      NULL,
      NULL,
      0.452770,
      NULL,
      NULL,
      0.124130,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.544377,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.674048,
      0.862121,
      NULL,
      1.457197,
      0,
      0.794460,
      1,
      NULL,
      1,
      0,
      0,
      1.671114,
      1.141964,
      NULL,
      0,
      0.312516,
      1,
      1,
      0.230506,
      NULL,
      0.895920,
      0.031476,
      0.623705,
      1.828446,
      1.166853,
      0.614665,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.325498,
      0,
      NULL,
      NULL,
      2,
      5.805770,
      5,
      3,
      5.541042,
      5.522554,
      6,
      1.132363,
      1.482576,
      0.603625,
      1,
      1,
      NULL,
      NULL,
      6.111360,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.917817,
      NULL,
      0,
      1,
      0,
      1.607308,
      0.237360,
      0.460107,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.236564,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.550790,
      0.829695,
      0.462405,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      1,
      0.859546,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.598405,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.366319,
      0,
      0,
      NULL,
      3.829692,
      NULL,
      NULL,
      1,
      1,
      0.449716,
      1.095151,
      0.217427,
      0,
      1.269691,
      1.876322,
      1,
      0.242234,
      1.456560,
      NULL,
      1.996569,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.801514,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6,
      NULL,
      '44200',
      '00131',
      NULL,
      '',
      '',
      '',
      0.719336,
      '',
      '',
      '',
      5.039071,
      1,
      0,
      NULL,
      0,
      2.635415,
      NULL,
      3,
      NULL);
commit;
end;
/


