set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8530746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-7-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '130',
      NULL,
      9,
      26.031693,
      '4412431',
      67.898759,
      3,
      3,
      0,
      '230022',
      3.829577,
      ' 2-10-1992',
      NULL,
      17.741999,
      1,
      NULL,
      1.258259,
      1.856156,
      1.622541,
      1.378727,
      0,
      0.988954,
      NULL,
      3,
      0.249056,
      0.975647,
      4,
      0,
      1.620588,
      0,
      0.174070,
      0.911960,
      5,
      1,
      1,
      0.526936,
      NULL,
      0.664090,
      1,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.244324,
      1,
      0.152405,
      0.392351,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.629488,
      1.037278,
      1.610299,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.339833,
      0.012657,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.479611,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.868619,
      0,
      0,
      1.970243,
      0,
      1.532816,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.052870,
      1.479965,
      0.992401,
      1,
      NULL,
      NULL,
      7,
      6.547916,
      4.311535,
      6.030261,
      3,
      NULL,
      1,
      0.018155,
      1.406604,
      NULL,
      NULL,
      6.964042,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.003562,
      1,
      1,
      0,
      0,
      NULL,
      0.156607,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.529699,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.673110,
      4,
      1.634431,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.120408,
      0.503139,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      0.049390,
      3.103802,
      0,
      0.404747,
      NULL,
      1,
      3.630828,
      1,
      NULL,
      0.461137,
      NULL,
      0,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7.909042,
      '10110',
      '02121',
      '02440',
      0,
      NULL,
      '',
      '',
      1.337043,
      NULL,
      '',
      '',
      2,
      2.367959,
      NULL,
      2,
      2,
      NULL,
      0,
      NULL,
      0.053149);
commit;
end;
/


