set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8530746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-12-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '124',
      NULL,
      70,
      38.467850,
      '0143313',
      5,
      2,
      NULL,
      1,
      NULL,
      3,
      ' 7-22-1986',
      5.659850,
      5,
      0.436853,
      NULL,
      1,
      NULL,
      0.779876,
      NULL,
      0.298040,
      NULL,
      0,
      NULL,
      1,
      0.003236,
      2,
      0,
      0.550496,
      NULL,
      1,
      0.571969,
      0.711192,
      0,
      1.319583,
      NULL,
      1,
      0,
      2.530838,
      1,
      1.759083,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0.831862,
      NULL,
      NULL,
      1,
      NULL,
      1.883007,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.092711,
      1.666733,
      1.624206,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.895448,
      0.348020,
      1,
      1,
      0.344169,
      1.751861,
      0,
      NULL,
      0.171670,
      1.389195,
      0,
      0.191275,
      1.618843,
      NULL,
      1.206333,
      0.494492,
      1.001467,
      0,
      0.277198,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.473916,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.448364,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.397583,
      3,
      5.612383,
      10.864866,
      NULL,
      2,
      6.738252,
      1.403097,
      0,
      0.845224,
      0,
      NULL,
      NULL,
      1.056256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.509708,
      0,
      1,
      0.590267,
      NULL,
      1.070808,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.463721,
      NULL,
      NULL,
      NULL,
      NULL,
      1.946168,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.024624,
      0.168013,
      0.136038,
      0,
      1.298119,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.146479,
      NULL,
      1,
      NULL,
      1,
      1.833121,
      0,
      NULL,
      0.039064,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      1.118576,
      0.582930,
      0.228818,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '33233',
      '30322',
      '04423',
      1,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      4.341923,
      2,
      0.366109,
      NULL,
      1.941040,
      NULL,
      NULL,
      4.587269,
      NULL);
commit;
end;
/


