set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8530746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-1-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '214',
      '33331341',
      NULL,
      46,
      '0444430',
      192,
      3,
      0,
      NULL,
      '312410',
      2.795393,
      NULL,
      1,
      NULL,
      0.047227,
      NULL,
      1.565681,
      1.890211,
      NULL,
      NULL,
      NULL,
      0,
      0.955186,
      2,
      NULL,
      NULL,
      5.014321,
      0,
      1,
      1.425243,
      1.584233,
      NULL,
      3.454226,
      1,
      1,
      0.197852,
      NULL,
      1,
      0.809511,
      NULL,
      0.098377,
      0,
      1.482666,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.401712,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.842258,
      0.989953,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.112770,
      NULL,
      0,
      0.593327,
      NULL,
      0.464183,
      NULL,
      0,
      0,
      0.169075,
      NULL,
      1.653871,
      1,
      1.655787,
      0.883973,
      0,
      NULL,
      1,
      1.752634,
      NULL,
      1.106949,
      0,
      1,
      1,
      0.652348,
      0.552397,
      NULL,
      0.665721,
      NULL,
      NULL,
      NULL,
      NULL,
      1.842204,
      NULL,
      1,
      1.514587,
      1,
      2.842998,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      1.340065,
      0.742683,
      1.780667,
      0.195749,
      NULL,
      NULL,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.302212,
      1,
      1,
      1.901450,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.246099,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.350361,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.555468,
      1.699691,
      4,
      4.717973,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.728712,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.071791,
      2,
      1,
      1,
      NULL,
      0,
      1,
      0,
      1.525476,
      2,
      1,
      0.925126,
      0,
      NULL,
      0.725447,
      0.765088,
      1.443218,
      NULL,
      1,
      1.558010,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      '44422',
      '40232',
      0.830659,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      2,
      2.184192,
      1.089806,
      3,
      1,
      1.629064,
      2.116099,
      4,
      1);
commit;
end;
/


