set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8530746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-1-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2441',
      '42142441',
      35.277245,
      59,
      '1310104',
      291,
      1,
      NULL,
      2,
      '420201',
      5,
      NULL,
      24,
      20.906790,
      0.425879,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1.148525,
      NULL,
      0.143704,
      3.416128,
      NULL,
      1.371110,
      0,
      NULL,
      1.743806,
      0.821741,
      0.146853,
      0.207246,
      1.545904,
      NULL,
      0.860703,
      0.846722,
      0.480992,
      0.727504,
      NULL,
      NULL,
      0.563312,
      0,
      1.368576,
      NULL,
      NULL,
      NULL,
      0.855811,
      NULL,
      NULL,
      0,
      0.836290,
      0.546491,
      1.016509,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.562465,
      0,
      0.159499,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      1.269902,
      0,
      NULL,
      1,
      1,
      0,
      0.746797,
      0,
      1,
      1,
      1.114742,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.239679,
      0.728376,
      1.110936,
      1,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.410506,
      1.598720,
      NULL,
      0,
      1,
      4,
      5,
      NULL,
      2.262409,
      NULL,
      5,
      NULL,
      0.206789,
      NULL,
      1.248431,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.913852,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.985839,
      0,
      1,
      1,
      0,
      1,
      1.178377,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3.799197,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.347612,
      1.569002,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.825919,
      0.311184,
      0.146336,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.716135,
      0,
      NULL,
      0.280302,
      NULL,
      0.994222,
      1,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0,
      0,
      1.052091,
      0.494081,
      0,
      1.636639,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.071441,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      '10131',
      '00112',
      '02433',
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      2.870341,
      2,
      3,
      2.806077,
      NULL,
      1.293746,
      NULL,
      1,
      NULL);
commit;
end;
/


