set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8530746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-7-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4431',
      '00041000',
      20,
      83.475392,
      NULL,
      313.119197,
      6,
      1,
      NULL,
      NULL,
      1.933031,
      ' 2-13-1996',
      30.833965,
      NULL,
      1,
      NULL,
      NULL,
      0.949476,
      0.061469,
      1,
      0.117260,
      0,
      0,
      2,
      0.025501,
      0.283410,
      4.261631,
      1.602453,
      NULL,
      1,
      0.941769,
      NULL,
      4,
      1,
      0,
      1.538425,
      NULL,
      0.455687,
      0,
      1,
      0.387138,
      1,
      0.975830,
      0.860222,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.730332,
      1.484008,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.337564,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.703649,
      1.638443,
      1.343100,
      0,
      1.196349,
      1.616740,
      1.189776,
      0.347528,
      1.842315,
      1,
      NULL,
      0.317303,
      1.520606,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.185778,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2.817959,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.246447,
      1.394267,
      NULL,
      5.466478,
      4,
      4,
      0.525541,
      NULL,
      3,
      4,
      2,
      1,
      0.860516,
      0.275896,
      0.819567,
      NULL,
      NULL,
      4.169705,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.365982,
      0,
      0,
      1,
      0.422001,
      1.102480,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.661600,
      NULL,
      NULL,
      NULL,
      NULL,
      0.426515,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.106338,
      NULL,
      NULL,
      NULL,
      1.941791,
      1.669941,
      4.278888,
      3.680755,
      0.696553,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3.447943,
      0.109426,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.685569,
      0,
      0,
      1.722486,
      0.666392,
      1.624743,
      1.446729,
      0.752159,
      1.610475,
      0.539835,
      0.187726,
      0.780256,
      NULL,
      1,
      1.249225,
      0.292959,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '11131',
      NULL,
      '30041',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      5.480714,
      2,
      3.301852,
      3.148134,
      1,
      1.699266,
      1,
      1,
      1);
commit;
end;
/


