set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8106369';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-8-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '033',
      '42041101',
      70,
      NULL,
      '3111213',
      0.506962,
      1,
      1.312185,
      3,
      NULL,
      1.780541,
      ' 0-22-1982',
      NULL,
      36,
      0,
      NULL,
      0,
      1.423800,
      NULL,
      0.599032,
      NULL,
      NULL,
      3.550553,
      3.474911,
      1,
      1,
      2,
      1.393768,
      0,
      0,
      0.944967,
      0.127866,
      0.117533,
      NULL,
      0.615142,
      0.801699,
      0.697962,
      1,
      1.548771,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.696847,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.699786,
      NULL,
      NULL,
      2.221109,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.936528,
      NULL,
      1.695252,
      1.723450,
      NULL,
      0.748808,
      0.228685,
      1.064885,
      NULL,
      3,
      0.009630,
      0,
      1,
      0.185757,
      0,
      1,
      0,
      0,
      1.578243,
      NULL,
      1,
      2.842076,
      NULL,
      1.191386,
      NULL,
      2,
      6.185956,
      NULL,
      0.453887,
      0,
      5.654508,
      0.436106,
      3.430284,
      NULL,
      3.256817,
      NULL,
      3,
      NULL,
      NULL,
      10.885483,
      6,
      7,
      1,
      3.178424,
      3,
      1.597860,
      NULL,
      NULL,
      0.018565,
      NULL,
      NULL,
      NULL,
      1.578315,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.827962,
      1,
      NULL,
      1,
      0,
      0,
      1.319891,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.531603,
      NULL,
      NULL,
      NULL,
      NULL,
      2.138760,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.523088,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.846370,
      3.264028,
      2.570763,
      0.902821,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.800706,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.196436,
      1.855773,
      0,
      1.055393,
      0.868535,
      2.489067,
      1.823289,
      3,
      0.699139,
      1,
      1.827299,
      NULL,
      0.906956,
      0,
      0.961973,
      0.623588,
      1,
      0.264392,
      1.829746,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5,
      '11341',
      '33213',
      '',
      1.606043,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      2,
      0,
      1.931380,
      0,
      NULL,
      5.583296,
      0.026568,
      2.399950,
      3);
commit;
end;
/


