set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8106369';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-2-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '22430331',
      55,
      44.683589,
      NULL,
      3,
      3,
      NULL,
      3,
      '433032',
      4,
      '11- 0-1982',
      32.062671,
      24,
      0.045589,
      NULL,
      2,
      1,
      0,
      0.203003,
      0,
      NULL,
      NULL,
      1,
      0.813579,
      NULL,
      1.453367,
      1,
      1.475427,
      1.642307,
      0,
      0,
      0.214954,
      0.711985,
      1,
      0.717312,
      1.313469,
      NULL,
      0.891117,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.858763,
      0.642045,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.846882,
      3.232621,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      5.872104,
      1.647861,
      1.953901,
      NULL,
      0.205782,
      0,
      0.075262,
      1.566840,
      0.918024,
      NULL,
      1,
      0.409859,
      NULL,
      1,
      0,
      NULL,
      1.641060,
      NULL,
      NULL,
      NULL,
      1,
      5,
      4,
      0.434800,
      3,
      1,
      NULL,
      5,
      4,
      2,
      2.757705,
      0.869423,
      3.192842,
      0.750032,
      4,
      9.919183,
      9.096161,
      0.954002,
      9,
      8.644704,
      3.029843,
      11,
      7.341546,
      0,
      5,
      2,
      1.054082,
      NULL,
      NULL,
      NULL,
      1.192103,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.629428,
      NULL,
      1,
      0,
      1.081155,
      0.474559,
      1,
      1.136251,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.113432,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.974695,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5,
      3,
      4,
      3.347357,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.783967,
      NULL,
      1.522860,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.180787,
      2.160858,
      NULL,
      NULL,
      0,
      1.095013,
      NULL,
      1.791236,
      3.810126,
      1,
      1,
      0,
      1,
      1.008308,
      0.548080,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '34240',
      '03320',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      2.016149,
      3,
      1.201003,
      NULL,
      NULL,
      NULL,
      2,
      0.333953,
      NULL);
commit;
end;
/


