set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8106369';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-8-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1002',
      '04042332',
      11.797640,
      68,
      '2240330',
      2.155127,
      NULL,
      0,
      NULL,
      '023230',
      NULL,
      ' 0-25-1997',
      24.927865,
      48.127638,
      1,
      NULL,
      2,
      1.363649,
      0,
      0,
      NULL,
      NULL,
      1.349038,
      0.659406,
      1,
      1.941609,
      0,
      1.699635,
      1,
      0,
      1.473412,
      1,
      NULL,
      0.534938,
      1.217930,
      1,
      0.769451,
      0,
      1.656550,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.697023,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.888340,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.662487,
      0.464000,
      2,
      0,
      1.426440,
      1.992426,
      NULL,
      NULL,
      NULL,
      0,
      0.936543,
      0.408367,
      0.957309,
      0,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      2.582929,
      1,
      1.878115,
      NULL,
      3.245640,
      1,
      3,
      0.686437,
      4.785345,
      0.240315,
      4,
      4.516136,
      NULL,
      0,
      2,
      8.864716,
      9,
      4.693316,
      9.372474,
      6.983286,
      NULL,
      8.229541,
      6.696344,
      4,
      NULL,
      1.145521,
      1,
      NULL,
      NULL,
      1.496018,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.391152,
      1,
      0,
      NULL,
      1,
      1,
      0.915550,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.306195,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.620877,
      2.951643,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      5.731280,
      0.419740,
      1,
      0.783973,
      NULL,
      NULL,
      NULL,
      1,
      0.172240,
      1.170480,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.687738,
      NULL,
      0,
      2,
      3.924777,
      3.496934,
      2.446230,
      1.801430,
      2.180587,
      1.210739,
      0,
      1.196248,
      1,
      0,
      1.560958,
      NULL,
      1.304750,
      0.525478,
      0.112248,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5,
      '10313',
      '42422',
      '',
      0,
      '',
      '',
      '',
      1.321491,
      '',
      '',
      '',
      NULL,
      NULL,
      2,
      1.920476,
      7.814862,
      NULL,
      3.925573,
      2,
      1.253787);
commit;
end;
/


