set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8106369';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-1-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1201',
      '43333021',
      NULL,
      59.185779,
      '0022440',
      21.023669,
      5,
      0.718568,
      1,
      '424222',
      NULL,
      ' 2-19-1991',
      NULL,
      25.658235,
      0.238680,
      NULL,
      0.126768,
      NULL,
      1,
      0,
      1,
      1.384742,
      2.119256,
      3.222155,
      NULL,
      1,
      2.667523,
      0.878598,
      1.161977,
      2,
      NULL,
      1,
      5,
      0,
      1.131853,
      0.017147,
      0,
      NULL,
      1.969894,
      1,
      3,
      3,
      0,
      0.360459,
      NULL,
      NULL,
      1.689292,
      NULL,
      NULL,
      2.688968,
      NULL,
      4.985878,
      3,
      0,
      0.575205,
      NULL,
      3,
      0,
      2.775699,
      3,
      0,
      0.194946,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0,
      1,
      1.533843,
      0,
      4.722140,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.163878,
      NULL,
      0.103921,
      1,
      0,
      1,
      1,
      0.932685,
      0,
      NULL,
      0,
      0,
      1.373457,
      NULL,
      0,
      1.196882,
      1.698167,
      0,
      NULL,
      1.208413,
      2.579637,
      1,
      0.719056,
      NULL,
      0,
      4,
      0,
      1,
      NULL,
      1.848374,
      1,
      3,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      9.976241,
      NULL,
      3.327039,
      NULL,
      8,
      0,
      5.845499,
      1.840437,
      3,
      0.862899,
      1,
      2.331452,
      NULL,
      1.988810,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.853538,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.610299,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.279136,
      NULL,
      0.451743,
      0.933605,
      5,
      0,
      2,
      NULL,
      0.451664,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.720511,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.149045,
      3.910234,
      2,
      1,
      NULL,
      0.376227,
      2,
      0,
      3.660465,
      0.975757,
      0,
      2.115283,
      NULL,
      NULL,
      NULL,
      0.190945,
      0.247376,
      0,
      NULL,
      0,
      1,
      1,
      0.872107,
      NULL,
      0.599415,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.134826,
      0.443372,
      0,
      0,
      NULL,
      1.619286,
      0,
      1.441128,
      NULL,
      0.861722,
      0.729444,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.637455,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.625358,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.805818,
      '10014',
      '04424',
      NULL,
      1,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '',
      2.748595,
      2.695185,
      0.107073,
      0,
      7.729056,
      5,
      3.571132,
      6,
      2.303494);
commit;
end;
/


